/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.List;
import org.apereo.cas.oidc.claims.OidcIdTokenClaimCollector;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OIDC")
class OidcIdTokenClaimCollectorTests {
    OidcIdTokenClaimCollectorTests() {
    }

    @Test
    void verifyDefaultOperation() throws Exception {
        JwtClaims claims = new JwtClaims();
        OidcIdTokenClaimCollector collector = OidcIdTokenClaimCollector.defaultCollector();
        collector.collect(claims, "claim1", List.of("value1"));
        collector.collect(claims, "claim2", List.of("value1", "value2"));
        Assertions.assertEquals((Object)"value1", (Object)claims.getStringClaimValue("claim1"));
        Assertions.assertEquals(List.of("value1", "value2"), (Object)claims.getStringListClaimValue("claim2"));
    }

    @Test
    void verifyListing() throws Exception {
        JwtClaims claims = new JwtClaims();
        OidcIdTokenClaimCollector collector = OidcIdTokenClaimCollector.listableCollector();
        collector.collect(claims, "claim1", List.of("value1"));
        collector.collect(claims, "claim2", List.of("value1", "value2"));
        Assertions.assertEquals(List.of("value1"), (Object)claims.getStringListClaimValue("claim1"));
        Assertions.assertEquals(List.of("value1", "value2"), (Object)claims.getStringListClaimValue("claim2"));
    }
}

