/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcOpenIdScopeAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="OIDC")
class OidcOpenIdScopeAttributeReleasePolicyTests
extends AbstractOidcTests {
    OidcOpenIdScopeAttributeReleasePolicyTests() {
    }

    @Test
    void verifyOperation() {
        OidcOpenIdScopeAttributeReleasePolicy policy = new OidcOpenIdScopeAttributeReleasePolicy();
        Assertions.assertEquals((Object)OidcConstants.StandardScopes.OPENID.getScope(), (Object)policy.getScopeType());
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().isEmpty());
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService()).principal(CoreAuthenticationTestUtils.getPrincipal()).build();
        Assertions.assertTrue((boolean)policy.determineRequestedAttributeDefinitions(context).isEmpty());
    }

    @Test
    void verifySerialization() {
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        OidcOpenIdScopeAttributeReleasePolicy policy = new OidcOpenIdScopeAttributeReleasePolicy();
        ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
        chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{policy});
        OidcRegisteredService service = OidcOpenIdScopeAttributeReleasePolicyTests.getOidcRegisteredService();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)chain);
        RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)appCtx);
        String json = serializer.toString((Object)service);
        Assertions.assertNotNull((Object)json);
        Assertions.assertNotNull((Object)serializer.from(json));
    }
}

