/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcPhoneScopeAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
class OidcPhoneScopeAttributeReleasePolicyTests {
    OidcPhoneScopeAttributeReleasePolicyTests() {
    }

    @Nested
    class DefaultTests
    extends AbstractOidcTests {
        DefaultTests() {
        }

        @Test
        void verifyOperation() {
            OidcPhoneScopeAttributeReleasePolicy policy = new OidcPhoneScopeAttributeReleasePolicy();
            Assertions.assertEquals((Object)OidcConstants.StandardScopes.PHONE.getScope(), (Object)policy.getScopeType());
            Assertions.assertNotNull((Object)policy.getAllowedAttributes());
            Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"phone_number_verified", List.of("12134321245"), (String)"phone_number", List.of("12134321245")));
            RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService()).principal(principal).build();
            Map attrs = policy.getAttributes(releasePolicyContext);
            Assertions.assertTrue((boolean)policy.getAllowedAttributes().stream().allMatch(attrs::containsKey));
            Assertions.assertTrue((boolean)policy.determineRequestedAttributeDefinitions(releasePolicyContext).containsAll(policy.getAllowedAttributes()));
        }

        @Test
        void verifySerialization() {
            StaticApplicationContext appCtx = new StaticApplicationContext();
            appCtx.refresh();
            OidcPhoneScopeAttributeReleasePolicy policy = new OidcPhoneScopeAttributeReleasePolicy();
            ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
            chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{policy});
            OidcRegisteredService service = DefaultTests.getOidcRegisteredService();
            service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)chain);
            RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)appCtx);
            String json = serializer.toString((Object)service);
            Assertions.assertNotNull((Object)json);
            Assertions.assertNotNull((Object)serializer.from(json));
        }
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oidc.core.claims-map.phone_number=cell_phone"})
    class ClaimMappingsTests
    extends AbstractOidcTests {
        ClaimMappingsTests() {
        }

        @Test
        void verifyMappedToUnknown() {
            OidcPhoneScopeAttributeReleasePolicy policy = new OidcPhoneScopeAttributeReleasePolicy();
            Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"phone_number", List.of("12134321245")));
            RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService()).principal(principal).build();
            Map attrs = policy.getAttributes(releasePolicyContext);
            Assertions.assertTrue((boolean)attrs.containsKey("phone_number"));
        }

        @Test
        void verifyMapped() {
            OidcPhoneScopeAttributeReleasePolicy policy = new OidcPhoneScopeAttributeReleasePolicy();
            Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"cell_phone", List.of("12134321245")));
            RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService()).principal(principal).build();
            Map attrs = policy.getAttributes(releasePolicyContext);
            Assertions.assertTrue((boolean)attrs.containsKey("phone_number"));
        }
    }
}

