/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcProfileScopeAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="OIDC")
class OidcProfileScopeAttributeReleasePolicyTests
extends AbstractOidcTests {
    OidcProfileScopeAttributeReleasePolicyTests() {
    }

    @Test
    void verifyOperation() {
        OidcProfileScopeAttributeReleasePolicy policy = new OidcProfileScopeAttributeReleasePolicy();
        Assertions.assertEquals((Object)OidcConstants.StandardScopes.PROFILE.getScope(), (Object)policy.getScopeType());
        Assertions.assertNotNull((Object)policy.getAllowedAttributes());
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"name", List.of("cas"), (String)"profile", List.of("test"), (String)"preferred_username", List.of("casuser"), (String)"family_name", List.of("given_name")));
        RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService()).principal(principal).build();
        Map attrs = policy.getAttributes(releasePolicyContext);
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().containsAll(attrs.keySet()));
        Assertions.assertTrue((boolean)policy.determineRequestedAttributeDefinitions(releasePolicyContext).containsAll(policy.getAllowedAttributes()));
    }

    @Test
    void verifySerialization() {
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        OidcProfileScopeAttributeReleasePolicy policy = new OidcProfileScopeAttributeReleasePolicy();
        policy.setAllowedAttributes(CollectionUtils.wrapList((Object[])new String[]{"name", "gender"}));
        ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
        chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{policy});
        OidcRegisteredService service = OidcProfileScopeAttributeReleasePolicyTests.getOidcRegisteredService();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)chain);
        RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)appCtx);
        String json = serializer.toString((Object)service);
        Assertions.assertNotNull((Object)json);
        RegisteredService read = (RegisteredService)serializer.from(json);
        Assertions.assertEquals((Object)read, (Object)service);
    }
}

