/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.List;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.claims.OidcIdTokenClaimCollector;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.attribute-repository.attribute-definition-store.json.location=classpath:/oidc-definitions.json"})
class OidcSimpleIdTokenClaimCollectorTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcIdTokenClaimCollector")
    private OidcIdTokenClaimCollector oidcIdTokenClaimCollector;

    OidcSimpleIdTokenClaimCollectorTests() {
    }

    @Test
    void verifyEmptyValue() {
        JwtClaims claims = new JwtClaims();
        this.oidcIdTokenClaimCollector.collect(claims, "unknown", List.of());
        Assertions.assertEquals((int)0, (int)claims.getClaimNames().size());
    }

    @Test
    void verifyUnknownDefinition() throws Exception {
        JwtClaims claims = new JwtClaims();
        this.oidcIdTokenClaimCollector.collect(claims, "unknown", List.of("value1", "value2"));
        Assertions.assertEquals((int)2, (int)claims.getStringListClaimValue("unknown").size());
    }

    @Test
    void verifyUnknownDefinitionAsSingle() throws Exception {
        JwtClaims claims = new JwtClaims();
        this.oidcIdTokenClaimCollector.collect(claims, "unknown", List.of("value1"));
        Assertions.assertEquals((Object)"value1", (Object)claims.getStringClaimValue("unknown"));
    }

    @Test
    void verifyMultiValueAsList() throws Exception {
        JwtClaims claims = new JwtClaims();
        this.oidcIdTokenClaimCollector.collect(claims, "mail", List.of("cas1@example.org", "cas2@example.org"));
        Assertions.assertEquals((int)2, (int)claims.getStringListClaimValue("mail").size());
    }

    @Test
    void verifySingleValueAsList() throws Exception {
        JwtClaims claims = new JwtClaims();
        this.oidcIdTokenClaimCollector.collect(claims, "mail", List.of("cas@example.org"));
        Assertions.assertEquals((int)1, (int)claims.getStringListClaimValue("mail").size());
    }

    @Test
    void verifySingleValueAsSingleValue() throws Exception {
        JwtClaims claims = new JwtClaims();
        this.oidcIdTokenClaimCollector.collect(claims, "cn", List.of("casuser"));
        Assertions.assertEquals((Object)"casuser", (Object)claims.getStringClaimValue("cn"));
    }
}

