/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.discovery.webfinger;

import java.util.Map;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.discovery.webfinger.OidcDefaultWebFingerDiscoveryService;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerUserInfoRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.http.ResponseEntity;

@Tag(value="OIDC")
class OidcDefaultWebFingerDiscoveryServiceTests
extends AbstractOidcTests {
    OidcDefaultWebFingerDiscoveryServiceTests() {
    }

    @Test
    void verifyNotFound() {
        ResponseEntity entity = this.oidcWebFingerDiscoveryService.handleRequest("resource", "http://openid.net/specs/connect/1.0/issuer");
        Assertions.assertEquals((int)404, (int)entity.getStatusCode().value());
    }

    @Test
    void verifyAccountMismatch() {
        ResponseEntity entity = this.oidcWebFingerDiscoveryService.handleRequest("okta:acct:joe.stormtrooper@example.com", "whatever");
        Assertions.assertEquals((int)404, (int)entity.getStatusCode().value());
    }

    @Test
    void verifyAccount() {
        ResponseEntity entity = this.oidcWebFingerDiscoveryService.handleRequest("okta:acct:joe.stormtrooper@sso.example.org", "http://openid.net/specs/connect/1.0/issuer");
        Assertions.assertEquals((int)200, (int)entity.getStatusCode().value());
    }

    @Test
    void verifyNoAccount() {
        OidcWebFingerUserInfoRepository repository = (OidcWebFingerUserInfoRepository)Mockito.mock(OidcWebFingerUserInfoRepository.class);
        Mockito.when((Object)repository.findByEmailAddress(Mockito.anyString())).thenReturn(Map.of());
        Mockito.when((Object)repository.findByUsername(Mockito.anyString())).thenReturn(Map.of());
        OidcDefaultWebFingerDiscoveryService service = new OidcDefaultWebFingerDiscoveryService(repository, new OidcServerDiscoverySettings("https://apereo.org/cas"));
        ResponseEntity entity = service.handleRequest("okta:acct:joe.stormtrooper@sso.example.org", "http://openid.net/specs/connect/1.0/issuer");
        Assertions.assertEquals((int)404, (int)entity.getStatusCode().value());
    }

    @Test
    void verifyMismatchResource() {
        ResponseEntity entity = this.oidcWebFingerDiscoveryService.handleRequest("", "http://openid.net/specs/connect/1.0/issuer");
        Assertions.assertEquals((int)404, (int)entity.getStatusCode().value());
    }
}

