/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.discovery.webfinger;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apereo.cas.configuration.model.RestEndpointProperties;
import org.apereo.cas.oidc.discovery.webfinger.userinfo.OidcRestfulWebFingerUserInfoRepository;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

@Tag(value="RestfulApi")
class OidcRestfulWebFingerUserInfoRepositoryTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private MockWebServer webServer;

    OidcRestfulWebFingerUserInfoRepositoryTests() {
    }

    @Test
    void verifyBadPayload() throws Exception {
        try (MockWebServer webServer = new MockWebServer(9312, (Resource)new ByteArrayResource("-@@-".getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
            this.webServer = webServer;
            this.webServer.start();
            Assertions.assertTrue((boolean)this.webServer.isRunning());
            RestEndpointProperties props = new RestEndpointProperties();
            props.setUrl("http://localhost:9312");
            OidcRestfulWebFingerUserInfoRepository repo = new OidcRestfulWebFingerUserInfoRepository(props);
            Map results = repo.findByEmailAddress("cas@example.org");
            Assertions.assertTrue((boolean)results.isEmpty());
        }
    }

    @Test
    void verifyFindByEmail() throws Exception {
        String data = MAPPER.writeValueAsString((Object)CollectionUtils.wrap((String)"email", (Object)"cas@example.org"));
        try (MockWebServer webServer = new MockWebServer(9312, (Resource)new ByteArrayResource(data.getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
            this.webServer = webServer;
            this.webServer.start();
            Assertions.assertTrue((boolean)this.webServer.isRunning());
            RestEndpointProperties props = new RestEndpointProperties();
            props.setUrl("http://localhost:9312");
            OidcRestfulWebFingerUserInfoRepository repo = new OidcRestfulWebFingerUserInfoRepository(props);
            Map results = repo.findByEmailAddress("cas@example.org");
            Assertions.assertNotNull((Object)results);
            Assertions.assertTrue((boolean)results.containsKey("email"));
            Assertions.assertEquals((Object)"cas@example.org", results.get("email"));
        }
    }

    @Test
    void verifyFindByUsername() throws Exception {
        String data = MAPPER.writeValueAsString((Object)CollectionUtils.wrap((String)"username", (Object)"casuser"));
        try (MockWebServer webServer = new MockWebServer(9312, (Resource)new ByteArrayResource(data.getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
            this.webServer = webServer;
            this.webServer.start();
            Assertions.assertTrue((boolean)this.webServer.isRunning());
            RestEndpointProperties props = new RestEndpointProperties();
            props.setUrl("http://localhost:9312");
            OidcRestfulWebFingerUserInfoRepository repo = new OidcRestfulWebFingerUserInfoRepository(props);
            Map results = repo.findByUsername("casuser");
            Assertions.assertNotNull((Object)results);
            Assertions.assertTrue((boolean)results.containsKey("username"));
            Assertions.assertEquals((Object)"casuser", results.get("username"));
        }
    }
}

