/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.issuer;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.services.OidcRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.core.accepted-issuers-pattern=https:..sso.example.org.*"})
class OidcDefaultIssuerServiceTests
extends AbstractOidcTests {
    OidcDefaultIssuerServiceTests() {
    }

    protected static JEEContext getContextForEndpoint(String endpoint) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.setServerName("sso.example.org");
        request.setServerPort(8443);
        request.setRequestURI("/cas/oidc/" + endpoint);
        MockHttpServletResponse response = new MockHttpServletResponse();
        return new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
    }

    @Test
    void verifyOperation() {
        Assertions.assertNotNull((Object)this.oidcIssuerService.determineIssuer(Optional.empty()));
    }

    @Test
    void verifyEchoingOperation() throws Exception {
        OidcRegisteredService svc = OidcDefaultIssuerServiceTests.getOidcRegisteredService();
        OidcIssuerService oidcService = OidcIssuerService.echoing((String)"https://custom.issuer/");
        Assertions.assertEquals((Object)"https://custom.issuer/", (Object)oidcService.determineIssuer(Optional.empty()));
        Assertions.assertEquals((Object)"https://custom.issuer/", (Object)oidcService.determineIssuer(Optional.of(svc)));
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertTrue((boolean)oidcService.validateIssuer((WebContext)context, "clientConfig"));
    }

    @Test
    void verifyServiceIssuer() {
        OidcRegisteredService svc = OidcDefaultIssuerServiceTests.getOidcRegisteredService();
        String issuer = this.oidcIssuerService.determineIssuer(Optional.of(svc));
        Assertions.assertEquals((Object)issuer, (Object)this.casProperties.getAuthn().getOidc().getCore().getIssuer());
        svc.setIdTokenIssuer("https://custom.issuer/");
        issuer = this.oidcIssuerService.determineIssuer(Optional.of(svc));
        Assertions.assertEquals((Object)"https://custom.issuer", (Object)issuer);
    }

    @Test
    void verifyIssuerPatterns() {
        Assertions.assertTrue((boolean)this.oidcIssuerService.validateIssuer((WebContext)OidcDefaultIssuerServiceTests.getContextForEndpoint("profile"), "profile"));
    }
}

