/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import java.io.File;
import java.util.Optional;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreModifiedEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

@Tag(value="OIDC")
class OidcDefaultJsonWebKeyStoreListenerTests
extends AbstractOidcTests {
    @Autowired
    private ConfigurableApplicationContext realApplicationContext;

    OidcDefaultJsonWebKeyStoreListenerTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        OidcJsonWebKeyCacheKey cacheKey = new OidcJsonWebKeyCacheKey(this.casProperties.getAuthn().getOidc().getCore().getIssuer(), OidcJsonWebKeyUsage.SIGNING);
        Optional keys = (Optional)this.oidcDefaultJsonWebKeystoreCache.get((Object)cacheKey);
        Assertions.assertNotNull((Object)keys);
        Assertions.assertNotNull((Object)this.oidcJsonWebKeyStoreListener);
        this.realApplicationContext.publishEvent((ApplicationEvent)new OidcJsonWebKeystoreModifiedEvent((Object)this, File.createTempFile("prefix", "postfix"), null));
        Thread.sleep(2000L);
        Optional newKeys = (Optional)this.oidcDefaultJsonWebKeystoreCache.getIfPresent((Object)cacheKey);
        Assertions.assertNull((Object)newKeys);
    }
}

