/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.OidcDefaultJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.util.ResourceUtils;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.jwks.core.jwks-type=ec", "cas.authn.oidc.jwks.core.jwks-key-size=384", "cas.authn.oidc.jwks.file-system.jwks-file=file:${#systemProperties['java.io.tmpdir']}/keystore.jwks"})
class OidcDefaultJsonWebKeystoreCacheLoaderTests
extends AbstractOidcTests {
    OidcDefaultJsonWebKeystoreCacheLoaderTests() {
    }

    @BeforeAll
    public static void setup() throws Exception {
        File file = new File(FileUtils.getTempDirectory(), "keystore.jwks");
        if (file.exists()) {
            FileUtils.delete((File)file);
        }
    }

    @Test
    void verifyNoWebKeys() {
        JsonWebKeySet jwks = new JsonWebKeySet(new JsonWebKey[0]);
        OidcDefaultJsonWebKeystoreCacheLoader loader = (OidcDefaultJsonWebKeystoreCacheLoader)Mockito.mock(OidcDefaultJsonWebKeystoreCacheLoader.class);
        Mockito.when((Object)loader.buildJsonWebKeySet((OidcJsonWebKeyCacheKey)Mockito.any(OidcJsonWebKeyCacheKey.class))).thenReturn(Optional.of(jwks));
        Mockito.when((Object)loader.load((OidcJsonWebKeyCacheKey)Mockito.any(OidcJsonWebKeyCacheKey.class))).thenCallRealMethod();
        Assertions.assertTrue((boolean)loader.load(new OidcJsonWebKeyCacheKey(UUID.randomUUID().toString(), OidcJsonWebKeyUsage.SIGNING)).isEmpty());
        jwks.getJsonWebKeys().add((JsonWebKey)Mockito.mock(JsonWebKey.class));
        Assertions.assertTrue((boolean)loader.load(new OidcJsonWebKeyCacheKey(UUID.randomUUID().toString(), OidcJsonWebKeyUsage.SIGNING)).isEmpty());
    }

    @Test
    void verifyBadKeyCount() throws Exception {
        JsonWebKeySet jwks = new JsonWebKeySet(new JsonWebKey[0]);
        PublicJsonWebKey jsonWebKey = (PublicJsonWebKey)Mockito.mock(PublicJsonWebKey.class);
        jwks.getJsonWebKeys().add(jsonWebKey);
        OidcDefaultJsonWebKeystoreCacheLoader loader = (OidcDefaultJsonWebKeystoreCacheLoader)Mockito.mock(OidcDefaultJsonWebKeystoreCacheLoader.class);
        Mockito.when((Object)loader.buildJsonWebKeySet((OidcJsonWebKeyCacheKey)Mockito.any(OidcJsonWebKeyCacheKey.class))).thenCallRealMethod();
        Mockito.when((Object)loader.load((OidcJsonWebKeyCacheKey)Mockito.any(OidcJsonWebKeyCacheKey.class))).thenCallRealMethod();
        Mockito.when((Object)loader.generateJwksResource()).thenReturn((Object)new ByteArrayResource("jwks".getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)loader.buildJsonWebKeySet((Resource)Mockito.any(Resource.class), (OidcJsonWebKeyCacheKey)Mockito.any(OidcJsonWebKeyCacheKey.class))).thenReturn((Object)jwks);
        Assertions.assertTrue((boolean)loader.load(new OidcJsonWebKeyCacheKey(UUID.randomUUID().toString(), OidcJsonWebKeyUsage.SIGNING)).isEmpty());
        Mockito.when((Object)jsonWebKey.getAlgorithm()).thenReturn((Object)"some-alg");
        Assertions.assertTrue((boolean)loader.load(new OidcJsonWebKeyCacheKey(UUID.randomUUID().toString(), OidcJsonWebKeyUsage.SIGNING)).isEmpty());
    }

    @Test
    void verifyOperation() {
        Optional publicJsonWebKey1 = (Optional)this.oidcDefaultJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey("https://sso.example.org/cas/oidc", OidcJsonWebKeyUsage.SIGNING));
        Assertions.assertNotNull((Object)publicJsonWebKey1);
        Assertions.assertTrue((boolean)publicJsonWebKey1.isPresent());
        Optional publicJsonWebKey2 = (Optional)this.oidcDefaultJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey("https://sso.example.org/cas/oidc", OidcJsonWebKeyUsage.SIGNING));
        Assertions.assertNotNull((Object)publicJsonWebKey2);
        Assertions.assertTrue((boolean)publicJsonWebKey2.isPresent());
    }

    @Test
    void verifyNullResource() throws Exception {
        OidcJsonWebKeystoreGeneratorService gen = (OidcJsonWebKeystoreGeneratorService)Mockito.mock(OidcJsonWebKeystoreGeneratorService.class);
        Mockito.when((Object)gen.generate()).thenReturn(null);
        OidcDefaultJsonWebKeystoreCacheLoader loader = new OidcDefaultJsonWebKeystoreCacheLoader(gen);
        Assertions.assertTrue((boolean)loader.load(new OidcJsonWebKeyCacheKey("https://cas.example.org", OidcJsonWebKeyUsage.SIGNING)).isEmpty());
    }

    @Test
    void verifyEmptyFile() throws Exception {
        OidcJsonWebKeystoreGeneratorService gen = (OidcJsonWebKeystoreGeneratorService)Mockito.mock(OidcJsonWebKeystoreGeneratorService.class);
        Mockito.when((Object)gen.generate()).thenReturn((Object)ResourceUtils.EMPTY_RESOURCE);
        OidcDefaultJsonWebKeystoreCacheLoader loader = new OidcDefaultJsonWebKeystoreCacheLoader(gen);
        Assertions.assertTrue((boolean)loader.load(new OidcJsonWebKeyCacheKey("https://cas.example.org", OidcJsonWebKeyUsage.SIGNING)).isEmpty());
        File file = File.createTempFile("keys", ".json");
        FileUtils.writeStringToFile((File)file, (String)new JsonWebKeySet(List.of()).toJson(), (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)gen.generate()).thenReturn((Object)new FileSystemResource(file));
        Assertions.assertTrue((boolean)loader.load(new OidcJsonWebKeyCacheKey("https://cas.example.org", OidcJsonWebKeyUsage.SIGNING)).isEmpty());
    }

    @Test
    void verifyBadKeys() throws Exception {
        OidcJsonWebKeystoreGeneratorService gen = (OidcJsonWebKeystoreGeneratorService)Mockito.mock(OidcJsonWebKeystoreGeneratorService.class);
        String keys = "{ \"keys\": [ {\"kty\":\"EC\",\"x\":\"sPlKwAgSxxOE\",\"y\":\"6AyisnUKM9H8\",\"crv\":\"P-256\"} ]}";
        Mockito.when((Object)gen.generate()).thenReturn((Object)new ByteArrayResource("{ \"keys\": [ {\"kty\":\"EC\",\"x\":\"sPlKwAgSxxOE\",\"y\":\"6AyisnUKM9H8\",\"crv\":\"P-256\"} ]}".getBytes(StandardCharsets.UTF_8)));
        OidcDefaultJsonWebKeystoreCacheLoader loader = new OidcDefaultJsonWebKeystoreCacheLoader(gen);
        Assertions.assertTrue((boolean)loader.load(new OidcJsonWebKeyCacheKey("https://cas.example.org", OidcJsonWebKeyUsage.SIGNING)).isEmpty());
    }
}

