/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreJacksonDeserializer;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OIDC")
class OidcJsonWebKeyStoreJacksonDeserializerTests
extends AbstractOidcTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    OidcJsonWebKeyStoreJacksonDeserializerTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        PublicJsonWebKey key = OidcJsonWebKeyStoreUtils.generateJsonWebKey((String)"rsa", (int)2048, (OidcJsonWebKeyUsage)OidcJsonWebKeyUsage.SIGNING);
        String keyset = new JsonWebKeySet(new JsonWebKey[]{key}).toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(JsonWebKeySet.class, (JsonDeserializer)new OidcJsonWebKeyStoreJacksonDeserializer());
        MAPPER.registerModule((Module)module);
        Assertions.assertNotNull((Object)MAPPER.readValue(keyset, JsonWebKeySet.class));
    }
}

