/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import java.util.List;
import java.util.Optional;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.services.OidcRegisteredService;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ResourceLoader;

@Tag(value="OIDC")
class OidcJsonWebKeyStoreUtilsTests
extends AbstractOidcTests {
    OidcJsonWebKeyStoreUtilsTests() {
    }

    @Test
    void verifyKeySet() {
        OidcRegisteredService service = OidcJsonWebKeyStoreUtilsTests.getOidcRegisteredService();
        service.setJwks("");
        Assertions.assertTrue((boolean)OidcJsonWebKeyStoreUtils.getJsonWebKeySet((OidcRegisteredService)service, (ResourceLoader)this.resourceLoader, Optional.of(OidcJsonWebKeyUsage.SIGNING)).isEmpty());
    }

    @Test
    void verifyBadSvc() {
        Assertions.assertTrue((boolean)OidcJsonWebKeyStoreUtils.getJsonWebKeySet(null, (ResourceLoader)this.resourceLoader, Optional.of(OidcJsonWebKeyUsage.SIGNING)).isEmpty());
    }

    @Test
    void verifyEmptyKeySet() {
        OidcRegisteredService service = OidcJsonWebKeyStoreUtilsTests.getOidcRegisteredService();
        service.setJwks(new JsonWebKeySet(List.of()).toJson());
        Assertions.assertTrue((boolean)OidcJsonWebKeyStoreUtils.getJsonWebKeySet((OidcRegisteredService)service, (ResourceLoader)this.resourceLoader, Optional.of(OidcJsonWebKeyUsage.SIGNING)).isEmpty());
    }

    @Test
    void verifyEc() {
        Assertions.assertNotNull((Object)OidcJsonWebKeyStoreUtils.generateJsonWebKey((String)"ec", (int)512, (OidcJsonWebKeyUsage)OidcJsonWebKeyUsage.SIGNING));
        Assertions.assertNotNull((Object)OidcJsonWebKeyStoreUtils.generateJsonWebKey((String)"ec", (int)256, (OidcJsonWebKeyUsage)OidcJsonWebKeyUsage.SIGNING));
    }

    @Test
    void verifyParsing() {
        PublicJsonWebKey key = OidcJsonWebKeyStoreUtils.generateJsonWebKey((String)"ec", (int)512, (OidcJsonWebKeyUsage)OidcJsonWebKeyUsage.SIGNING);
        JsonWebKeySet keyset = new JsonWebKeySet(new JsonWebKey[]{key});
        Assertions.assertNotNull((Object)OidcJsonWebKeyStoreUtils.parseJsonWebKeySet((String)keyset.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE)));
    }
}

