/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import java.util.Optional;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OIDC")
class OidcRegisteredServiceJsonWebKeystoreCacheLoaderTests
extends AbstractOidcTests {
    OidcRegisteredServiceJsonWebKeystoreCacheLoaderTests() {
    }

    @Test
    void verifyOperation() {
        OidcRegisteredService service = OidcRegisteredServiceJsonWebKeystoreCacheLoaderTests.getOidcRegisteredService(UUID.randomUUID().toString());
        Assertions.assertTrue((boolean)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey((OAuthRegisteredService)service, OidcJsonWebKeyUsage.SIGNING))).isPresent());
        Assertions.assertTrue((boolean)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey((OAuthRegisteredService)service, OidcJsonWebKeyUsage.SIGNING))).isPresent());
    }

    @Test
    void verifyOperationWithOAuth() {
        OAuthRegisteredService service = OidcRegisteredServiceJsonWebKeystoreCacheLoaderTests.getOAuthRegisteredService("clientid", "secret");
        Assertions.assertTrue((boolean)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey(service, OidcJsonWebKeyUsage.SIGNING))).isEmpty());
        Assertions.assertTrue((boolean)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey(service, OidcJsonWebKeyUsage.SIGNING))).isEmpty());
    }

    @Test
    void verifyOperationWithKidPerServiceMissing() {
        OidcRegisteredService service = OidcRegisteredServiceJsonWebKeystoreCacheLoaderTests.getOidcRegisteredService(UUID.randomUUID().toString());
        service.setJwksKeyId("myCustomKey");
        Assertions.assertTrue((boolean)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey((OAuthRegisteredService)service, OidcJsonWebKeyUsage.SIGNING))).isEmpty());
    }

    @Test
    void verifyOperationWithKidPerServicePresent() {
        OidcRegisteredService service = OidcRegisteredServiceJsonWebKeystoreCacheLoaderTests.getOidcRegisteredService(UUID.randomUUID().toString());
        service.setJwksKeyId("1234567890");
        service.setJwks("classpath:servicekid.jwks");
        Assertions.assertTrue((boolean)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey((OAuthRegisteredService)service, OidcJsonWebKeyUsage.SIGNING))).isPresent());
    }
}

