/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.generator;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.support.CasConfigurationJasyptCipherExecutor;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.generator.OidcDefaultJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.util.RandomUtils;
import org.jose4j.jwk.JsonWebKeySet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
class OidcDefaultJsonWebKeystoreGeneratorServiceTests {
    OidcDefaultJsonWebKeystoreGeneratorServiceTests() {
    }

    static {
        System.setProperty(CasConfigurationJasyptCipherExecutor.JasyptEncryptionParameters.PASSWORD.getPropertyName(), "P@$$w0rd");
    }

    @TestPropertySource(properties={"cas.authn.oidc.jwks.file-system.jwks-file=file:${#systemProperties['java.io.tmpdir']}/something.jwks"})
    @Nested
    class DefaultTests
    extends AbstractOidcTests {
        private File keystore;

        DefaultTests() {
        }

        @BeforeEach
        public void setup() {
            this.keystore = new File(FileUtils.getTempDirectoryPath(), "something.jwks");
            if (this.keystore.exists()) {
                Assertions.assertTrue((boolean)this.keystore.delete());
            }
        }

        @Test
        void verifyOperation() throws Exception {
            Resource resource = this.oidcJsonWebKeystoreGeneratorService.generate();
            Assertions.assertTrue((boolean)resource.exists());
            Assertions.assertTrue((boolean)this.keystore.setLastModified(new Date().getTime()));
            Thread.sleep(2000L);
            this.oidcJsonWebKeystoreGeneratorService.store(OidcJsonWebKeystoreGeneratorService.toJsonWebKeyStore((Resource)resource));
            Assertions.assertTrue((boolean)this.oidcJsonWebKeystoreGeneratorService.find().isPresent());
            ((DisposableBean)this.oidcJsonWebKeystoreGeneratorService).destroy();
        }

        @Test
        void verifyRegeneration() throws Exception {
            Resource resource1 = this.oidcJsonWebKeystoreGeneratorService.generate();
            Assertions.assertTrue((boolean)resource1.exists());
            Resource resource2 = this.oidcJsonWebKeystoreGeneratorService.generate();
            Assertions.assertTrue((boolean)resource2.exists());
        }

        @Test
        void verifyCurve256() throws Exception {
            OidcProperties properties = new OidcProperties();
            properties.getJwks().getCore().setJwksType("ec");
            properties.getJwks().getCore().setJwksKeySize(256);
            this.verifyGeneration(properties);
        }

        @Test
        void verifyCurve384() throws Exception {
            OidcProperties properties = new OidcProperties();
            properties.getJwks().getCore().setJwksType("ec");
            properties.getJwks().getCore().setJwksKeySize(384);
            this.verifyGeneration(properties);
        }

        @Test
        void verifyCurve521() throws Exception {
            OidcProperties properties = new OidcProperties();
            properties.getJwks().getCore().setJwksType("ec");
            properties.getJwks().getCore().setJwksKeySize(521);
            this.verifyGeneration(properties);
        }

        private void verifyGeneration(OidcProperties properties) throws Exception {
            File file = Files.createTempFile(RandomUtils.randomAlphabetic((int)6), ".jwks", new FileAttribute[0]).toFile();
            properties.getJwks().getFileSystem().setJwksFile(file.getAbsolutePath());
            OidcDefaultJsonWebKeystoreGeneratorService service = new OidcDefaultJsonWebKeystoreGeneratorService(properties, this.applicationContext);
            service.generate((Resource)new FileSystemResource(file));
            Assertions.assertTrue((boolean)file.exists());
            service.destroy();
        }
    }

    @TestPropertySource(properties={"cas.authn.oidc.jwks.file-system.jwks-file=classpath:/encrypted.jwks"})
    @Nested
    class EncryptedKeystoreTests
    extends AbstractOidcTests {
        EncryptedKeystoreTests() {
        }

        @Test
        void verifyOperation() throws Exception {
            Optional resource = this.oidcJsonWebKeystoreGeneratorService.find();
            Assertions.assertTrue((boolean)resource.isPresent());
            JsonWebKeySet jwks = new JsonWebKeySet(IOUtils.toString((InputStream)((Resource)resource.get()).getInputStream(), (Charset)StandardCharsets.UTF_8));
            Assertions.assertFalse((boolean)jwks.getJsonWebKeys().isEmpty());
        }
    }

    @TestPropertySource(properties={"cas.authn.oidc.jwks.file-system.jwks-file={\"keys\": []}"})
    @Nested
    class EmbeddedKeystoreTests
    extends AbstractOidcTests {
        EmbeddedKeystoreTests() {
        }

        @Test
        void verifyOperation() throws Exception {
            Optional resource = this.oidcJsonWebKeystoreGeneratorService.find();
            Assertions.assertTrue((boolean)resource.isPresent());
            JsonWebKeySet jwks = new JsonWebKeySet(IOUtils.toString((InputStream)((Resource)resource.get()).getInputStream(), (Charset)StandardCharsets.UTF_8));
            Assertions.assertTrue((boolean)jwks.getJsonWebKeys().isEmpty());
        }
    }
}

