/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.generator;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.Resource;
import org.springframework.test.context.TestPropertySource;

@Tag(value="Groovy")
@TestPropertySource(properties={"cas.authn.oidc.jwks.groovy.location=classpath:GroovyJwksService.groovy"})
class OidcGroovyJsonWebKeystoreGeneratorServiceTests
extends AbstractOidcTests {
    OidcGroovyJsonWebKeystoreGeneratorServiceTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        Resource resource = this.oidcJsonWebKeystoreGeneratorService.generate();
        Assertions.assertTrue((boolean)resource.exists());
        Assertions.assertTrue((boolean)this.oidcJsonWebKeystoreGeneratorService.find().isPresent());
        Assertions.assertDoesNotThrow(() -> {
            String results = new String(IOUtils.toByteArray((InputStream)resource.getInputStream()), StandardCharsets.UTF_8);
            new JsonWebKeySet(results);
        });
    }

    @Test
    void verifyStoreOperation() throws Exception {
        JsonWebKeySet jwks = new JsonWebKeySet(new JsonWebKey[]{OidcJsonWebKeystoreGeneratorService.generateJsonWebKey((OidcProperties)this.casProperties.getAuthn().getOidc(), (OidcJsonWebKeyUsage)OidcJsonWebKeyUsage.ENCRYPTION)});
        Assertions.assertNotNull((Object)this.oidcJsonWebKeystoreGeneratorService.store(jwks));
    }
}

