/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.generator;

import java.nio.charset.StandardCharsets;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.OidcRestfulJsonWebKeystoreGeneratorService;
import org.apereo.cas.util.MockWebServer;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.TestPropertySource;

@Tag(value="RestfulApi")
@TestPropertySource(properties={"cas.authn.oidc.jwks.rest.url=http://localhost:9521", "cas.authn.oidc.jwks.rest.basic-auth-username=casuser", "cas.authn.oidc.jwks.rest.basic-auth-password=123456"})
class OidcRestfulJsonWebKeystoreGeneratorServiceTests
extends AbstractOidcTests {
    private static MockWebServer SERVER;

    OidcRestfulJsonWebKeystoreGeneratorServiceTests() {
    }

    @BeforeAll
    public static void setup() {
        PublicJsonWebKey webKey = OidcJsonWebKeyStoreUtils.generateJsonWebKey((String)"rsa", (int)2048, (OidcJsonWebKeyUsage)OidcJsonWebKeyUsage.SIGNING);
        String data = webKey.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
        SERVER = new MockWebServer(9521, (Resource)new ByteArrayResource(data.getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");
        SERVER.start();
    }

    @AfterAll
    public static void clean() {
        SERVER.close();
    }

    @Test
    void verifyOperation() throws Exception {
        Resource resource = this.oidcJsonWebKeystoreGeneratorService.generate();
        Assertions.assertTrue((boolean)resource.exists());
        Assertions.assertTrue((boolean)this.oidcJsonWebKeystoreGeneratorService.find().isPresent());
        JsonWebKeySet jwks = new JsonWebKeySet(new JsonWebKey[]{OidcJsonWebKeystoreGeneratorService.generateJsonWebKey((OidcProperties)this.casProperties.getAuthn().getOidc(), (OidcJsonWebKeyUsage)OidcJsonWebKeyUsage.SIGNING)});
        Assertions.assertNotNull((Object)this.oidcJsonWebKeystoreGeneratorService.store(jwks));
    }

    @Test
    void verifyFailsOperation() throws Exception {
        OidcProperties oidcProperties = new OidcProperties();
        oidcProperties.getJwks().getRest().setUrl("https://localhost:1234");
        oidcProperties.getJwks().getRest().setMethod("get");
        Resource resource = new OidcRestfulJsonWebKeystoreGeneratorService(oidcProperties).generate();
        Assertions.assertNull((Object)resource);
    }
}

