/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.rotation;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
class OidcDefaultJsonWebKeystoreRotationServiceTests {
    OidcDefaultJsonWebKeystoreRotationServiceTests() {
    }

    private static long countPreviousKeys(JsonWebKeySet jwks) {
        return jwks.getJsonWebKeys().stream().filter(key -> OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.getJsonWebKeyState((JsonWebKey)key).isPrevious()).count();
    }

    private static long countCurrentKeys(JsonWebKeySet jwks) {
        return jwks.getJsonWebKeys().stream().filter(key -> OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.getJsonWebKeyState((JsonWebKey)key).isCurrent()).count();
    }

    private static long countFutureKeys(JsonWebKeySet jwks) {
        return jwks.getJsonWebKeys().stream().filter(key -> OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.getJsonWebKeyState((JsonWebKey)key).isFuture()).count();
    }

    static {
        try {
            File keystore = new File(FileUtils.getTempDirectoryPath(), "rotation.jwks");
            if (keystore.exists()) {
                Assertions.assertTrue((boolean)keystore.delete());
            }
            File current = new File(FileUtils.getTempDirectoryPath(), "current.jwks");
            current.delete();
            FileUtils.copyFile((File)new ClassPathResource("current.jwks").getFile(), (File)current);
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
    }

    @TestPropertySource(properties={"cas.authn.oidc.jwks.file-system.jwks-file=file:${#systemProperties['java.io.tmpdir']}/current.jwks"})
    @Nested
    class ExistingKeystoreTests
    extends AbstractOidcTests {
        ExistingKeystoreTests() {
        }

        @Test
        void verifyOperation() throws Exception {
            JsonWebKeySet jwks = this.oidcJsonWebKeystoreRotationService.rotate();
            Assertions.assertEquals((int)5, (int)jwks.getJsonWebKeys().size());
        }
    }

    @TestPropertySource(properties={"cas.authn.oidc.jwks.file-system.jwks-file=file:${#systemProperties['java.io.tmpdir']}/rotation.jwks"})
    @Nested
    class EmptyKeystoreTests
    extends AbstractOidcTests {
        EmptyKeystoreTests() {
        }

        @Test
        void verifyOperation() throws Exception {
            JsonWebKeySet jwks = this.oidcJsonWebKeystoreRotationService.rotate();
            Assertions.assertEquals((int)6, (int)jwks.getJsonWebKeys().size());
            Assertions.assertEquals((long)2L, (long)OidcDefaultJsonWebKeystoreRotationServiceTests.countCurrentKeys(jwks));
            Assertions.assertEquals((long)2L, (long)OidcDefaultJsonWebKeystoreRotationServiceTests.countFutureKeys(jwks));
            Assertions.assertEquals((long)2L, (long)OidcDefaultJsonWebKeystoreRotationServiceTests.countPreviousKeys(jwks));
            jwks = this.oidcJsonWebKeystoreRotationService.rotate();
            Assertions.assertEquals((int)8, (int)jwks.getJsonWebKeys().size());
            Assertions.assertEquals((long)2L, (long)OidcDefaultJsonWebKeystoreRotationServiceTests.countCurrentKeys(jwks));
            Assertions.assertEquals((long)2L, (long)OidcDefaultJsonWebKeystoreRotationServiceTests.countFutureKeys(jwks));
            Assertions.assertEquals((long)4L, (long)OidcDefaultJsonWebKeystoreRotationServiceTests.countPreviousKeys(jwks));
            jwks = this.oidcJsonWebKeystoreRotationService.rotate();
            Assertions.assertEquals((int)10, (int)jwks.getJsonWebKeys().size());
            Assertions.assertEquals((long)2L, (long)OidcDefaultJsonWebKeystoreRotationServiceTests.countCurrentKeys(jwks));
            Assertions.assertEquals((long)2L, (long)OidcDefaultJsonWebKeystoreRotationServiceTests.countFutureKeys(jwks));
            Assertions.assertEquals((long)6L, (long)OidcDefaultJsonWebKeystoreRotationServiceTests.countPreviousKeys(jwks));
            jwks = this.oidcJsonWebKeystoreRotationService.revoke();
            Assertions.assertEquals((int)4, (int)jwks.getJsonWebKeys().size());
            Assertions.assertEquals((long)2L, (long)OidcDefaultJsonWebKeystoreRotationServiceTests.countCurrentKeys(jwks));
            Assertions.assertEquals((long)2L, (long)OidcDefaultJsonWebKeystoreRotationServiceTests.countFutureKeys(jwks));
            Assertions.assertEquals((long)0L, (long)OidcDefaultJsonWebKeystoreRotationServiceTests.countPreviousKeys(jwks));
        }
    }
}

