/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import java.util.Map;
import java.util.Set;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcProfileScopeAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ReturnAllAttributeReleasePolicy;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="OIDC")
class OidcProfileScopeToAttributesFilterTests
extends AbstractOidcTests {
    OidcProfileScopeToAttributesFilterTests() {
    }

    @Test
    void verifyOAuth() {
        OAuthRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOAuthRegisteredService("example", "https://example.org");
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Principal original = CoreAuthenticationTestUtils.getPrincipal();
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, accessToken);
        Assertions.assertEquals((Object)original, (Object)principal);
    }

    @Test
    void verifyOperationFilterWithoutOpenId() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Principal original = CoreAuthenticationTestUtils.getPrincipal();
        Assertions.assertFalse((boolean)original.getAttributes().isEmpty());
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, accessToken);
        Assertions.assertEquals((Object)original, (Object)principal);
        Assertions.assertTrue((boolean)principal.getAttributes().isEmpty());
    }

    @Test
    void verifyScopeFreeWithOpenIdScope() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getScopes()).thenReturn((Object)CollectionUtils.wrapSet((Object)OidcConstants.StandardScopes.OPENID.getScope()));
        service.getScopes().clear();
        service.getScopes().add(OidcConstants.StandardScopes.OPENID.getScope());
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
        Principal original = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", (Object)"casuser@example.org", (String)"address", (Object)"1234 Main Street", (String)"phone", (Object)"123445677", (String)"name", (Object)"CAS", (String)"gender", (Object)"male"));
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, accessToken);
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("name"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("address"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("gender"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("email"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("phone"));
    }

    @Test
    void verifyOperationFilterWithOpenId() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getScopes()).thenReturn((Object)CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.OPENID.getScope(), OidcConstants.StandardScopes.PHONE.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.ADDRESS.getScope(), OidcConstants.StandardScopes.EMAIL.getScope()}));
        service.getScopes().add(OidcConstants.StandardScopes.EMAIL.getScope());
        service.getScopes().add(OidcConstants.StandardScopes.ADDRESS.getScope());
        service.getScopes().add(OidcConstants.StandardScopes.PHONE.getScope());
        service.getScopes().add(OidcConstants.StandardScopes.PROFILE.getScope());
        Principal original = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", (Object)"casuser@example.org", (String)"address", (Object)"1234 Main Street", (String)"phone", (Object)"123445677", (String)"name", (Object)"CAS", (String)"gender", (Object)"male"));
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, accessToken);
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("name"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("address"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("gender"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("email"));
        Assertions.assertEquals((int)4, (int)principal.getAttributes().size());
    }

    @Test
    void verifyOperationFilterWithServiceDefinedScopes() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getScopes()).thenReturn((Object)CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.OPENID.getScope(), OidcConstants.StandardScopes.PHONE.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.ADDRESS.getScope(), OidcConstants.StandardScopes.EMAIL.getScope()}));
        service.getScopes().clear();
        service.getScopes().add(OidcConstants.StandardScopes.EMAIL.getScope());
        Principal original = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", (Object)"casuser@example.org", (String)"address", (Object)"1234 Main Street", (String)"phone", (Object)"123445677", (String)"name", (Object)"CAS", (String)"gender", (Object)"male"));
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, accessToken);
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("email"));
        Assertions.assertEquals((int)1, (int)principal.getAttributes().size());
    }

    @Test
    void verifyOperationFilterWithServiceDefinedReleasePolicy() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getScopes()).thenReturn((Object)CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.OPENID.getScope(), OidcConstants.StandardScopes.PHONE.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.ADDRESS.getScope(), OidcConstants.StandardScopes.EMAIL.getScope()}));
        service.getScopes().clear();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new OidcProfileScopeAttributeReleasePolicy());
        Principal original = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", (Object)"casuser@example.org", (String)"address", (Object)"1234 Main Street", (String)"phone", (Object)"123445677", (String)"name", (Object)"CAS", (String)"gender", (Object)"male"));
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, accessToken);
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("name"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("gender"));
        Assertions.assertEquals((int)2, (int)principal.getAttributes().size());
    }

    @Test
    void verifyByUserInfoClaims() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getClaims()).thenReturn(Map.of("userinfo", Map.of("name", "{\"essential\": true}", "gender", "{\"essential\": true}")));
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getScopes()).thenReturn((Object)CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.OPENID.getScope()}));
        service.getScopes().clear();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new OidcProfileScopeAttributeReleasePolicy());
        Principal original = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", (Object)"casuser@example.org", (String)"address", (Object)"1234 Main Street", (String)"phone", (Object)"123445677", (String)"name", (Object)"CAS", (String)"gender", (Object)"male"));
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, accessToken);
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("name"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("gender"));
        Assertions.assertEquals((int)2, (int)principal.getAttributes().size());
    }

    @Test
    void verifyAccessTokenNoScopes() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getScopes()).thenReturn(Set.of(OidcConstants.StandardScopes.OPENID.getScope()));
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new OidcProfileScopeAttributeReleasePolicy());
        Principal original = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", (Object)"casuser@example.org", (String)"address", (Object)"1234 Main Street", (String)"phone", (Object)"123445677", (String)"name", (Object)"CAS", (String)"gender", (Object)"male"));
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, accessToken);
        Assertions.assertTrue((boolean)principal.getAttributes().isEmpty());
    }
}

