/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
class OidcUserProfileDataCreatorTests {
    OidcUserProfileDataCreatorTests() {
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oauth.access-token.crypto.encryption-enabled=false", "cas.authn.oidc.id-token.include-id-token-claims=true"})
    class DefaultTests
    extends AbstractOidcTests {
        DefaultTests() {
        }

        @Test
        void verifyOperation() throws Exception {
            JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
            OAuth20AccessToken accessToken = this.getAccessToken();
            Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, (WebContext)context);
            Assertions.assertFalse((boolean)data.isEmpty());
            Assertions.assertEquals((long)accessToken.getTicketGrantingTicket().getAuthentication().getAuthenticationDate().toEpochSecond(), (long)((Long)data.get("auth_time")));
            Assertions.assertTrue((boolean)data.containsKey("sub"));
            Assertions.assertTrue((boolean)data.containsKey("id"));
            Assertions.assertTrue((boolean)data.containsKey("client_id"));
            Assertions.assertTrue((boolean)data.containsKey("attributes"));
            Assertions.assertTrue((boolean)data.containsKey("service"));
            Map attrs = (Map)data.get("attributes");
            Assertions.assertTrue((boolean)attrs.containsKey("email"));
        }

        @Test
        void verifyTokenWithClaims() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
            String claims = "\"userinfo\": {\"given_name\": {\"essential\": true}}";
            request.addParameter("claims", "\"userinfo\": {\"given_name\": {\"essential\": true}}");
            Map result = this.oauthRequestParameterResolver.resolveRequestClaims((WebContext)context);
            OAuth20AccessToken accessToken = this.getAccessToken();
            Mockito.when((Object)accessToken.getClaims()).thenReturn((Object)result);
            Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, (WebContext)context);
            Assertions.assertFalse((boolean)data.isEmpty());
            Assertions.assertTrue((boolean)data.containsKey("sub"));
        }
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oauth.core.user-profile-view-type=FLAT", "cas.authn.oidc.core.claims-map.email=email-address"})
    class WithClaimMappingsTests
    extends AbstractOidcTests {
        WithClaimMappingsTests() {
        }

        @Test
        void verifyOperation() throws Exception {
            JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
            Principal principal = RegisteredServiceTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)"email", List.of("casuser@example.org"), (String)"email-address", List.of("casuser@apereo.org")));
            OAuth20AccessToken accessToken = this.getAccessToken(principal);
            Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, (WebContext)context);
            Map attrs = (Map)data.get("attributes");
            Assertions.assertFalse((boolean)attrs.containsKey("email-address"));
            Assertions.assertTrue((boolean)attrs.containsKey("email"));
            Assertions.assertEquals((Object)"casuser@apereo.org", CollectionUtils.firstElement(attrs.get("email")).get());
        }
    }
}

