/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import java.util.Optional;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.discovery.user-info-encryption-alg-values-supported=none,RSA1_5,RSA-OAEP-256"})
class OidcUserProfileSigningAndEncryptionServiceTests
extends AbstractOidcTests {
    OidcUserProfileSigningAndEncryptionServiceTests() {
    }

    @Test
    void verifyOperation() {
        OidcRegisteredService service = OidcUserProfileSigningAndEncryptionServiceTests.getOidcRegisteredService();
        service.setUserInfoEncryptedResponseEncoding("A128CBC-HS256");
        service.setUserInfoEncryptedResponseAlg("RSA-OAEP-256");
        service.setUserInfoSigningAlg("RS256");
        String input = this.oidcUserProfileSigningAndEncryptionService.encode((OAuthRegisteredService)service, this.getClaims());
        Assertions.assertFalse((boolean)input.isEmpty());
        Assertions.assertDoesNotThrow(() -> this.oidcUserProfileSigningAndEncryptionService.decode(input, Optional.of(service)));
    }

    @Test
    void verifyOAuth() {
        OAuthRegisteredService service = OidcUserProfileSigningAndEncryptionServiceTests.getOAuthRegisteredService("example", "https://example.org");
        String input = this.oidcUserProfileSigningAndEncryptionService.encode(service, this.getClaims());
        Assertions.assertFalse((boolean)input.isEmpty());
    }

    @Test
    void verifyNoSigningEncryption() {
        OidcRegisteredService service = OidcUserProfileSigningAndEncryptionServiceTests.getOidcRegisteredService();
        service.setUserInfoSigningAlg("RS256");
        service.setUserInfoEncryptedResponseEncoding("A128CBC-HS256");
        service.setUserInfoEncryptedResponseAlg("none");
        String input = this.oidcUserProfileSigningAndEncryptionService.encode((OAuthRegisteredService)service, this.getClaims());
        Assertions.assertFalse((boolean)input.isEmpty());
    }
}

