/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class OidcUserProfileViewRendererDefaultTests
extends AbstractOidcTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    OidcUserProfileViewRendererDefaultTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response);
        OAuth20AccessToken accessToken = this.getAccessToken();
        Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, (WebContext)context);
        ResponseEntity entity = this.oidcUserProfileViewRenderer.render(data, accessToken, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNotNull((Object)entity.getBody());
        Map result = (Map)MAPPER.readValue(entity.getBody().toString(), Map.class);
        Assertions.assertTrue((boolean)result.containsKey("auth_time"));
        Assertions.assertTrue((boolean)result.containsKey("sub"));
        Assertions.assertTrue((boolean)result.containsKey("id"));
        Assertions.assertTrue((boolean)result.containsKey("client_id"));
        Assertions.assertTrue((boolean)result.containsKey("attributes"));
        Assertions.assertTrue((boolean)result.containsKey("service"));
        Map attrs = (Map)result.get("attributes");
        Assertions.assertTrue((boolean)attrs.containsKey("email"));
        Assertions.assertEquals((Object)"casuser@example.org", CollectionUtils.firstElement(attrs.get("email")).get());
    }

    @Test
    void verifyOperationOAuth() throws Exception {
        String clientId = UUID.randomUUID().toString();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response);
        OAuth20AccessToken accessToken = this.getAccessToken(clientId);
        OAuthRegisteredService service = OidcUserProfileViewRendererDefaultTests.getOAuthRegisteredService(clientId, "https://somthing.com");
        this.servicesManager.save((RegisteredService)service);
        Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, (WebContext)context);
        ResponseEntity entity = this.oidcUserProfileViewRenderer.render(data, accessToken, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNotNull((Object)entity.getBody());
    }

    @Test
    void verifyOperationEncryptedAndSigned() throws Exception {
        String clientId = UUID.randomUUID().toString();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response);
        OAuth20AccessToken accessToken = this.getAccessToken(clientId);
        OidcRegisteredService service = OidcUserProfileViewRendererDefaultTests.getOidcRegisteredService(clientId);
        service.setUserInfoEncryptedResponseEncoding("A128CBC-HS256");
        service.setUserInfoEncryptedResponseAlg("RSA-OAEP-256");
        service.setUserInfoSigningAlg("RS256");
        service.setSignIdToken(true);
        service.setEncryptIdToken(true);
        this.servicesManager.save((RegisteredService)service);
        Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, (WebContext)context);
        ResponseEntity entity = this.oidcUserProfileViewRenderer.render(data, accessToken, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNotNull((Object)entity.getBody());
    }

    @Test
    void verifyOperationSigned() throws Exception {
        String clientId = UUID.randomUUID().toString();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response);
        OAuth20AccessToken accessToken = this.getAccessToken(clientId);
        OidcRegisteredService service = OidcUserProfileViewRendererDefaultTests.getOidcRegisteredService(clientId);
        service.setUserInfoSigningAlg("RS256");
        service.setSignIdToken(true);
        service.setEncryptIdToken(false);
        this.servicesManager.save((RegisteredService)service);
        Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, (WebContext)context);
        ResponseEntity entity = this.oidcUserProfileViewRenderer.render(data, accessToken, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)entity);
        String body = (String)entity.getBody();
        Assertions.assertNotNull((Object)body);
        JWTClaimsSet claims = JwtBuilder.parse((String)body);
        Assertions.assertNotNull((Object)claims);
        Assertions.assertEquals((Object)"casuser@example.org", ((Map)claims.getClaim("attributes")).get("email"));
        Assertions.assertEquals((Object)"https://sso.example.org/cas/oidc", (Object)claims.getIssuer());
    }
}

