/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.discovery.user-info-signing-alg-values-supported=RS256", "cas.authn.oidc.discovery.user-info-encryption-alg-values-supported=RSA1_5,RSA-OAEP,RSA-OAEP-256,A128KW,A192KW,A256KW", "cas.authn.oauth.core.user-profile-view-type=FLAT"})
class OidcUserProfileViewRendererFlatTests
extends AbstractOidcTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    OidcUserProfileViewRendererFlatTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response);
        OAuth20AccessToken accessToken = this.getAccessToken();
        Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, (WebContext)context);
        ResponseEntity entity = this.oidcUserProfileViewRenderer.render(data, accessToken, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNotNull((Object)entity.getBody());
        Map result = (Map)MAPPER.readValue(entity.getBody().toString(), Map.class);
        Assertions.assertTrue((boolean)result.containsKey("auth_time"));
        Assertions.assertTrue((boolean)result.containsKey("sub"));
        Assertions.assertTrue((boolean)result.containsKey("id"));
        Assertions.assertTrue((boolean)result.containsKey("client_id"));
        Assertions.assertTrue((boolean)result.containsKey("service"));
        Assertions.assertTrue((boolean)result.containsKey("email"));
        String values = result.get("email").toString();
        Assertions.assertEquals((Object)"casuser@example.org", (Object)values);
    }

    @Test
    void verifyOperationJWS() throws Exception {
        String clientId = UUID.randomUUID().toString();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response);
        OAuth20AccessToken accessToken = this.getAccessToken(clientId);
        OidcRegisteredService service = OidcUserProfileViewRendererFlatTests.getOidcRegisteredService(clientId);
        service.setUserInfoSigningAlg("RS256");
        service.setSignIdToken(true);
        service.setEncryptIdToken(false);
        this.servicesManager.save((RegisteredService)service);
        Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, (WebContext)context);
        ResponseEntity entity = this.oidcUserProfileViewRenderer.render(data, accessToken, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)entity);
        String body = (String)entity.getBody();
        Assertions.assertNotNull((Object)body);
        JWTClaimsSet claims = JwtBuilder.parse((String)body);
        Assertions.assertNotNull((Object)claims);
        Assertions.assertEquals((Object)"casuser@example.org", (Object)claims.getClaim("email"));
        Assertions.assertEquals((Object)"https://sso.example.org/cas/oidc", (Object)claims.getIssuer());
    }

    @Test
    void verifyFailsOperation() throws Exception {
        String id = UUID.randomUUID().toString();
        OidcRegisteredService service = OidcUserProfileViewRendererFlatTests.getOidcRegisteredService(id);
        service.setUserInfoSigningAlg("none");
        service.setUserInfoEncryptedResponseAlg("none");
        this.servicesManager.save((RegisteredService)service);
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response);
        OAuth20AccessToken accessToken = this.getAccessToken(id);
        Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, (WebContext)context);
        ResponseEntity entity = this.oidcUserProfileViewRenderer.render(data, accessToken, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)entity.getStatusCode());
        service.setUserInfoSigningAlg("RS256");
        service.setUserInfoEncryptedResponseAlg("none");
        this.servicesManager.save((RegisteredService)service);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)this.oidcUserProfileViewRenderer.render(data, accessToken, (HttpServletResponse)response).getStatusCode());
    }
}

