/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.scopes;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.scopes.OidcAttributeReleasePolicyFactory;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceChainingAttributeReleasePolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Tag(value="OIDC")
class DefaultOidcAttributeReleasePolicyFactoryTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcAttributeReleasePolicyFactory")
    private OidcAttributeReleasePolicyFactory oidcAttributeReleasePolicyFactory;

    DefaultOidcAttributeReleasePolicyFactoryTests() {
    }

    @Test
    void verifyOperation() {
        Assertions.assertNotNull((Object)this.oidcAttributeReleasePolicyFactory.get(OidcConstants.StandardScopes.EMAIL));
        Assertions.assertNotNull((Object)this.oidcAttributeReleasePolicyFactory.get(OidcConstants.StandardScopes.ADDRESS));
        Assertions.assertNotNull((Object)this.oidcAttributeReleasePolicyFactory.get(OidcConstants.StandardScopes.PHONE));
        Assertions.assertNotNull((Object)this.oidcAttributeReleasePolicyFactory.get(OidcConstants.StandardScopes.ADDRESS));
        Assertions.assertNotNull((Object)this.oidcAttributeReleasePolicyFactory.get(OidcConstants.StandardScopes.OPENID));
        Assertions.assertNotNull((Object)this.oidcAttributeReleasePolicyFactory.get(OidcConstants.StandardScopes.OFFLINE_ACCESS));
    }

    @Test
    void verifyEffectivePolicies() {
        OidcRegisteredService registeredService = DefaultOidcAttributeReleasePolicyFactoryTests.getOidcRegisteredService(UUID.randomUUID().toString());
        registeredService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new OidcCustomScopeAttributeReleasePolicy("eduPerson", List.of("uid")));
        Map policies = this.oidcAttributeReleasePolicyFactory.resolvePolicies(registeredService);
        Assertions.assertTrue((boolean)policies.containsKey("eduPerson"));
        Assertions.assertTrue((boolean)policies.containsKey(OidcConstants.StandardScopes.EMAIL.getScope()));
        Assertions.assertTrue((boolean)policies.containsKey(OidcConstants.StandardScopes.PROFILE.getScope()));
        Assertions.assertTrue((boolean)policies.containsKey(OidcConstants.StandardScopes.OPENID.getScope()));
        Assertions.assertTrue((boolean)policies.containsKey(OidcConstants.StandardScopes.ADDRESS.getScope()));
    }

    @Test
    void verifyEffectivePoliciesWithChain() {
        OidcRegisteredService registeredService = DefaultOidcAttributeReleasePolicyFactoryTests.getOidcRegisteredService(UUID.randomUUID().toString());
        RegisteredServiceChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy().addPolicies(new RegisteredServiceAttributeReleasePolicy[]{new OidcCustomScopeAttributeReleasePolicy("eduPerson", List.of("uid"))});
        registeredService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)chain);
        Map policies = this.oidcAttributeReleasePolicyFactory.resolvePolicies(registeredService);
        Assertions.assertTrue((boolean)policies.containsKey("eduPerson"));
        Assertions.assertTrue((boolean)policies.containsKey(OidcConstants.StandardScopes.EMAIL.getScope()));
        Assertions.assertTrue((boolean)policies.containsKey(OidcConstants.StandardScopes.PROFILE.getScope()));
    }
}

