/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.services;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.PartialRegexRegisteredServiceMatchingStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMatchingStrategy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.query.RegisteredServiceQuery;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Tag(value="OIDC")
class OidcServicesManagerRegisteredServiceLocatorTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcServicesManagerRegisteredServiceLocator")
    private ServicesManagerRegisteredServiceLocator oidcServicesManagerRegisteredServiceLocator;

    OidcServicesManagerRegisteredServiceLocatorTests() {
    }

    @BeforeEach
    public void setup() {
        this.servicesManager.deleteAll();
    }

    @Test
    void verifyFindByQuery() {
        OidcRegisteredService service1 = OidcServicesManagerRegisteredServiceLocatorTests.getOidcRegisteredService(UUID.randomUUID().toString());
        OidcRegisteredService service2 = OidcServicesManagerRegisteredServiceLocatorTests.getOidcRegisteredService(UUID.randomUUID().toString());
        this.servicesManager.save(new RegisteredService[]{service1, service2});
        Assertions.assertEquals((long)1L, (long)this.servicesManager.findServicesBy(new RegisteredServiceQuery[]{RegisteredServiceQuery.of(OidcRegisteredService.class, (String)"id", (Object)service1.getId())}).count());
        Assertions.assertEquals((long)1L, (long)this.servicesManager.findServicesBy(new RegisteredServiceQuery[]{RegisteredServiceQuery.of(OidcRegisteredService.class, (String)"id", (Object)service2.getId()), RegisteredServiceQuery.of(OidcRegisteredService.class, (String)"clientId", (Object)service2.getClientId()), RegisteredServiceQuery.of(OidcRegisteredService.class, (String)"name", (Object)service2.getName())}).count());
        Assertions.assertEquals((long)0L, (long)this.servicesManager.findServicesBy(new RegisteredServiceQuery[]{RegisteredServiceQuery.of(CasRegisteredService.class, (String)"clientId", (Object)service1.getClientId())}).count());
        Assertions.assertEquals((long)0L, (long)this.servicesManager.findServicesBy(new RegisteredServiceQuery[]{RegisteredServiceQuery.of(OAuthRegisteredService.class, (String)"clientId", (Object)service1.getClientId())}).count());
        Assertions.assertEquals((long)1L, (long)this.servicesManager.findServicesBy(new RegisteredServiceQuery[]{RegisteredServiceQuery.of(OAuthRegisteredService.class, (String)"clientId", (Object)service1.getClientId()).withIncludeAssignableTypes(true)}).count());
    }

    @Test
    void verifyWithCallback() throws Exception {
        String callbackUrl = "http://localhost:8443/cas/oauth2.0/callbackAuthorize";
        CasRegisteredService service0 = RegisteredServiceTestUtils.getRegisteredService((String)"http://localhost:8443/cas/oauth2.0/callbackAuthorize.*");
        service0.setEvaluationOrder(0);
        OidcRegisteredService service1 = OidcServicesManagerRegisteredServiceLocatorTests.getOidcRegisteredService("application1");
        service1.setEvaluationOrder(100);
        OidcRegisteredService service2 = OidcServicesManagerRegisteredServiceLocatorTests.getOidcRegisteredService("application-catch-all", ".*");
        service2.setEvaluationOrder(1000);
        List candidateServices = CollectionUtils.wrapList((Object[])new BaseWebBasedRegisteredService[]{service0, service1, service2});
        this.servicesManager.save(candidateServices.toArray(new RegisteredService[0]));
        Collections.sort(candidateServices);
        URIBuilder url = new URIBuilder("http://localhost:8443/cas/oauth2.0/callbackAuthorize?client_id=application1");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("http://localhost:8443/cas/oauth2.0/callbackAuthorize");
        url.getQueryParams().forEach(param -> request.addParameter(param.getName(), param.getValue()));
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService(url.toString());
        RegisteredService result = this.servicesManager.findServiceBy((Service)service);
        Assertions.assertEquals((Object)result, (Object)service1);
        Assertions.assertFalse((boolean)this.oidcServicesManagerRegisteredServiceLocator.getRegisteredServiceIndexes().isEmpty());
    }

    @Test
    void verifyOperation() {
        Assertions.assertNotNull((Object)this.oidcServicesManagerRegisteredServiceLocator);
        Assertions.assertEquals((int)-2147483647, (int)this.oidcServicesManagerRegisteredServiceLocator.getOrder());
        String clientId = UUID.randomUUID().toString();
        OidcRegisteredService service = OidcServicesManagerRegisteredServiceLocatorTests.getOidcRegisteredService(clientId);
        service.setMatchingStrategy((RegisteredServiceMatchingStrategy)new PartialRegexRegisteredServiceMatchingStrategy());
        WebApplicationService svc = (WebApplicationService)this.webApplicationServiceFactory.createService(String.format("https://oauth.example.org/whatever?%s=%s", "client_id", clientId));
        RegisteredService result = this.oidcServicesManagerRegisteredServiceLocator.locate(List.of(service), (Service)svc);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void verifyReverseOperation() {
        CasRegisteredService service1 = RegisteredServiceTestUtils.getRegisteredService((String)".+");
        service1.setEvaluationOrder(5);
        String oidcClientId = UUID.randomUUID().toString();
        OidcRegisteredService service2 = OidcServicesManagerRegisteredServiceLocatorTests.getOidcRegisteredService(oidcClientId, ".+", false, false);
        service2.setEvaluationOrder(10);
        String oauthClientId = UUID.randomUUID().toString();
        OAuthRegisteredService service3 = OidcServicesManagerRegisteredServiceLocatorTests.getOAuthRegisteredService(oauthClientId, ".+");
        service3.setEvaluationOrder(15);
        this.servicesManager.save(new RegisteredService[]{service1, service2, service3});
        WebApplicationService svc = (WebApplicationService)this.webApplicationServiceFactory.createService(String.format("https://app.example.org/whatever?%s=%s", "client_id", oidcClientId));
        RegisteredService result = this.servicesManager.findServiceBy((Service)svc);
        Assertions.assertTrue((boolean)(result instanceof OidcRegisteredService));
        svc = (WebApplicationService)this.webApplicationServiceFactory.createService("https://app.example.org/whatever?hello=world");
        result = this.servicesManager.findServiceBy((Service)svc);
        Assertions.assertTrue((boolean)(result instanceof CasRegisteredService));
    }
}

