/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.slo;

import java.util.Collection;
import java.util.UUID;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.SingleLogoutExecutionRequest;
import org.apereo.cas.logout.slo.SingleLogoutServiceMessageHandler;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceLogoutType;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Tag(value="OIDC")
class OidcSingleLogoutServiceMessageHandlerTests
extends AbstractOidcTests {
    private static final String LOGOUT_URL_OK = "https://mocky.io/post";
    private static final String LOGOUT_URL_BAD = "https://unknown-1234-unknown.xyz";
    @Autowired
    @Qualifier(value="oidcSingleLogoutServiceMessageHandler")
    private SingleLogoutServiceMessageHandler oidcSingleLogoutServiceMessageHandler;

    OidcSingleLogoutServiceMessageHandlerTests() {
    }

    @Test
    void verifyCreateLogoutRequestsFrontChannel() {
        this.verifyCreateLogoutRequests(RegisteredServiceLogoutType.FRONT_CHANNEL, LOGOUT_URL_OK);
    }

    @Test
    void verifyCreateLogoutRequestsBackChannel() {
        this.verifyCreateLogoutRequests(RegisteredServiceLogoutType.BACK_CHANNEL, LOGOUT_URL_OK);
    }

    @Test
    void verifyUnknownRequestsBackChannel() {
        this.verifyCreateLogoutRequests(RegisteredServiceLogoutType.BACK_CHANNEL, LOGOUT_URL_BAD);
    }

    @BeforeEach
    public void setup() {
        this.servicesManager.deleteAll();
    }

    private void verifyCreateLogoutRequests(RegisteredServiceLogoutType type, String logoutUrl) {
        OidcRegisteredService registeredService = OidcSingleLogoutServiceMessageHandlerTests.getOidcRegisteredService("clientid", logoutUrl + ".*");
        registeredService.setLogoutType(type);
        registeredService.setLogoutUrl(logoutUrl);
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)(logoutUrl + "?client_id=" + registeredService.getClientId()));
        service.getAttributes().remove("service");
        this.servicesManager.save((RegisteredService)registeredService);
        SingleLogoutExecutionRequest executionRequest = SingleLogoutExecutionRequest.builder().ticketGrantingTicket((TicketGrantingTicket)new MockTicketGrantingTicket("casuser")).build();
        Assertions.assertTrue((boolean)this.oidcSingleLogoutServiceMessageHandler.supports(executionRequest, (WebApplicationService)service));
        Collection requests = this.oidcSingleLogoutServiceMessageHandler.handle((WebApplicationService)service, UUID.randomUUID().toString(), executionRequest);
        Assertions.assertEquals((int)1, (int)requests.size());
    }
}

