/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.ticket;

import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequest;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestFactory;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;

@Tag(value="OIDC")
class OidcDefaultPushedAuthorizationRequestFactoryTests
extends AbstractOidcTests {
    OidcDefaultPushedAuthorizationRequestFactoryTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        OidcRegisteredService registeredService = OidcDefaultPushedAuthorizationRequestFactoryTests.getOidcRegisteredService();
        CommonProfile profile = new CommonProfile();
        profile.setId("casTest");
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().clientId(registeredService.getClientId()).service((Service)RegisteredServiceTestUtils.getService()).authentication(RegisteredServiceTestUtils.getAuthentication()).registeredService((OAuthRegisteredService)registeredService).grantType(OAuth20GrantTypes.AUTHORIZATION_CODE).responseType(OAuth20ResponseTypes.CODE).userProfile((UserProfile)profile).build();
        OidcPushedAuthorizationRequestFactory factory = (OidcPushedAuthorizationRequestFactory)this.defaultTicketFactory.get(OidcPushedAuthorizationRequest.class);
        OidcPushedAuthorizationRequest ticket = factory.create(holder);
        Assertions.assertNotNull((Object)ticket);
        Assertions.assertTrue((boolean)ticket.getId().startsWith("OPAR"));
        Assertions.assertSame(OidcPushedAuthorizationRequest.class, (Object)factory.getTicketType());
        long expiration = Beans.newDuration((String)this.casProperties.getAuthn().getOidc().getPar().getMaxTimeToLiveInSeconds()).getSeconds();
        Assertions.assertEquals((long)expiration, (Long)ticket.getExpirationPolicy().getTimeToLive());
        AccessTokenRequestContext atRequest = factory.toAccessTokenRequest(ticket);
        Assertions.assertEquals((Object)holder.getAuthentication(), (Object)atRequest.getAuthentication());
        Assertions.assertEquals((Object)holder.getService(), (Object)atRequest.getService());
        Assertions.assertEquals((Object)holder.getRegisteredService(), (Object)atRequest.getRegisteredService());
        Assertions.assertEquals((Object)holder.getClientId(), (Object)atRequest.getClientId());
        Assertions.assertEquals((Object)holder.getUserProfile().getId(), (Object)atRequest.getUserProfile().getId());
    }
}

