/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.ticket;

import java.util.LinkedHashMap;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
class OidcPushedAuthorizationModelAndViewBuilderTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcPushedAuthorizationModelAndViewBuilder")
    private OAuth20AuthorizationModelAndViewBuilder oidcPushedAuthorizationModelAndViewBuilder;

    OidcPushedAuthorizationModelAndViewBuilderTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("expires_in", "100");
        parameters.put("request_uri", UUID.randomUUID().toString());
        ModelAndView mv = this.oidcPushedAuthorizationModelAndViewBuilder.build((OAuthRegisteredService)OidcPushedAuthorizationModelAndViewBuilderTests.getOidcRegisteredService(), OAuth20ResponseModeTypes.FORM_POST, "https://example.com", parameters);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("expires_in"));
        Assertions.assertTrue((boolean)mv.getModel().containsKey("request_uri"));
        Assertions.assertEquals((Object)HttpStatus.CREATED, (Object)mv.getStatus());
    }
}

