/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.ticket;

import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequest;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestFactory;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.serialization.TicketSerializationManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Tag(value="OIDC")
class OidcPushedAuthorizationRequestTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="ticketSerializationManager")
    private TicketSerializationManager ticketSerializationManager;

    OidcPushedAuthorizationRequestTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        CommonProfile profile = new CommonProfile();
        profile.setId("casuser");
        OidcRegisteredService registeredService = OidcPushedAuthorizationRequestTests.getOidcRegisteredService();
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().clientId(registeredService.getClientId()).service((Service)RegisteredServiceTestUtils.getService()).authentication(RegisteredServiceTestUtils.getAuthentication()).registeredService((OAuthRegisteredService)registeredService).grantType(OAuth20GrantTypes.AUTHORIZATION_CODE).responseType(OAuth20ResponseTypes.CODE).userProfile((UserProfile)profile).build();
        OidcPushedAuthorizationRequestFactory factory = (OidcPushedAuthorizationRequestFactory)this.defaultTicketFactory.get(OidcPushedAuthorizationRequest.class);
        OidcPushedAuthorizationRequest ticket = factory.create(holder);
        this.verifySerialization((Ticket)ticket);
    }

    private void verifySerialization(Ticket ticket) {
        String serialized = this.ticketSerializationManager.serializeTicket(ticket);
        Assertions.assertNotNull((Object)serialized);
        Ticket deserialized = this.ticketSerializationManager.deserializeTicket(serialized, ticket.getClass());
        Assertions.assertNotNull((Object)deserialized);
        Assertions.assertEquals((Object)deserialized, (Object)ticket);
    }
}

