/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.ticket;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequest;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.Ticket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.tgc.crypto.enabled=false", "cas.authn.oidc.par.max-time-to-live-in-seconds=5", "cas.authn.oidc.par.number-of-uses=1"})
class OidcPushedAuthorizationRequestUriResponseBuilderTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcPushedAuthorizationRequestResponseBuilder")
    private OAuth20AuthorizationResponseBuilder oidcPushedAuthorizationRequestResponseBuilder;

    OidcPushedAuthorizationRequestUriResponseBuilderTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        Assertions.assertEquals((int)0, (int)this.oidcPushedAuthorizationRequestResponseBuilder.getOrder());
        OidcRegisteredService registeredService = OidcPushedAuthorizationRequestUriResponseBuilderTests.getOidcRegisteredService();
        CommonProfile profile = new CommonProfile();
        profile.setId("casuser");
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().clientId(registeredService.getClientId()).service((Service)RegisteredServiceTestUtils.getService()).authentication(RegisteredServiceTestUtils.getAuthentication((String)"casuser", Map.of("customAttribute", List.of("CASUSER-ORIGINAL")))).registeredService((OAuthRegisteredService)registeredService).grantType(OAuth20GrantTypes.AUTHORIZATION_CODE).responseType(OAuth20ResponseTypes.CODE).userProfile((UserProfile)profile).build();
        OAuth20AuthorizationRequest authzRequest = OAuth20AuthorizationRequest.builder().clientId(registeredService.getClientId()).url("oidcPushAuthorize").grantType(OAuth20GrantTypes.AUTHORIZATION_CODE.getType()).responseType(OAuth20ResponseTypes.CODE.getType()).build();
        Assertions.assertTrue((boolean)this.oidcPushedAuthorizationRequestResponseBuilder.supports(authzRequest));
        ModelAndView mv = this.oidcPushedAuthorizationRequestResponseBuilder.build(holder);
        Assertions.assertTrue((boolean)mv.getModel().containsKey("expires_in"));
        String uri = mv.getModel().get("request_uri").toString();
        OidcPushedAuthorizationRequest ticket = (OidcPushedAuthorizationRequest)this.ticketRegistry.getTicket(uri, OidcPushedAuthorizationRequest.class);
        Assertions.assertNotNull((Object)ticket);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/oidcPushAuthorize");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        authzRequest = ((OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder)this.oidcPushedAuthorizationRequestResponseBuilder.toAuthorizationRequest((WebContext)context, holder.getAuthentication(), holder.getService(), holder.getRegisteredService()).get()).build();
        Assertions.assertNotNull((Object)authzRequest);
        Assertions.assertFalse((boolean)authzRequest.isSingleSignOnSessionRequired());
        request.addParameter("request_uri", uri);
        Authentication authn = RegisteredServiceTestUtils.getAuthentication((String)"casuser", Map.of("customAttribute", List.of("CASUSER-TGT")));
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket(authn);
        this.ticketRegistry.addTicket((Ticket)tgt);
        Cookie cookie = this.ticketGrantingTicketCookieGenerator.addCookie((HttpServletRequest)request, (HttpServletResponse)response, tgt.getId());
        request.setCookies(new Cookie[]{cookie});
        context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        authzRequest = ((OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder)this.oidcPushedAuthorizationRequestResponseBuilder.toAuthorizationRequest((WebContext)context, holder.getAuthentication(), holder.getService(), holder.getRegisteredService()).get()).build();
        AccessTokenRequestContext accessTokenRequest = authzRequest.getAccessTokenRequest();
        Assertions.assertTrue((boolean)authzRequest.isSingleSignOnSessionRequired());
        Assertions.assertNotNull((Object)accessTokenRequest.getAuthentication());
        Assertions.assertNotNull((Object)accessTokenRequest.getRegisteredService());
        Assertions.assertNotNull((Object)accessTokenRequest.getResponseType());
        Assertions.assertNotNull((Object)accessTokenRequest.getGrantType());
        Assertions.assertNotNull((Object)accessTokenRequest.getTicketGrantingTicket());
        List customAttribute = (List)accessTokenRequest.getAuthentication().getAttributes().get("customAttribute");
        Assertions.assertEquals(List.of("CASUSER-TGT", "CASUSER-ORIGINAL"), (Object)customAttribute);
        Assertions.assertThrows(InvalidTicketException.class, () -> this.ticketRegistry.getTicket(uri, OidcPushedAuthorizationRequest.class));
    }
}

