/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.ticket;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequest;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestFactory;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.Ticket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class OidcPushedAuthorizationRequestValidatorTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcPushedAuthorizationRequestValidator")
    private OAuth20AuthorizationRequestValidator oidcPushedAuthorizationRequestValidator;

    OidcPushedAuthorizationRequestValidatorTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        OidcRegisteredService registeredService = OidcPushedAuthorizationRequestValidatorTests.getOidcRegisteredService();
        CommonProfile profile = new CommonProfile();
        profile.setId("casTest");
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().clientId(registeredService.getClientId()).service((Service)RegisteredServiceTestUtils.getService()).authentication(RegisteredServiceTestUtils.getAuthentication()).registeredService((OAuthRegisteredService)registeredService).grantType(OAuth20GrantTypes.AUTHORIZATION_CODE).responseType(OAuth20ResponseTypes.CODE).userProfile((UserProfile)profile).build();
        OidcPushedAuthorizationRequestFactory factory = (OidcPushedAuthorizationRequestFactory)this.defaultTicketFactory.get(OidcPushedAuthorizationRequest.class);
        OidcPushedAuthorizationRequest ticket = factory.create(holder);
        Assertions.assertNotNull((Object)ticket);
        this.ticketRegistry.addTicket((Ticket)ticket);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", holder.getClientId());
        request.addParameter("request_uri", ticket.getId());
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertTrue((boolean)this.oidcPushedAuthorizationRequestValidator.supports((WebContext)context));
        Assertions.assertTrue((boolean)this.oidcPushedAuthorizationRequestValidator.validate((WebContext)context));
        Assertions.assertEquals((int)0, (int)this.oidcPushedAuthorizationRequestValidator.getOrder());
    }
}

