/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.services.DefaultRegisteredServiceOidcIdTokenExpirationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceOidcIdTokenExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20AccessTokenAtHashGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.RepetitionInfo;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
class OidcIdTokenGeneratorServiceTests {
    private static final String OIDC_CLAIM_EMAIL = "email";
    private static final String OIDC_CLAIM_PHONE_NUMBER = "phone_number";
    private static final String OIDC_CLAIM_NAME = "name";
    private static final String OIDC_CLAIM_PREFERRED_USERNAME = "preferred_username";

    OidcIdTokenGeneratorServiceTests() {
    }

    private OAuth20AccessToken buildAccessToken(MockTicketGrantingTicket tgt) {
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getAuthentication()).thenReturn((Object)tgt.getAuthentication());
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)tgt);
        Mockito.when((Object)accessToken.getId()).thenReturn((Object)this.getClass().getSimpleName());
        Mockito.when((Object)accessToken.getClientId()).thenReturn((Object)"client");
        Mockito.when((Object)accessToken.getScopes()).thenReturn(Set.of(OidcConstants.StandardScopes.OPENID.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PHONE.getScope()));
        return accessToken;
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oidc.id-token.include-id-token-claims=false", "cas.authn.oauth.access-token.crypto.encryption-enabled=false", "cas.authn.oidc.core.claims-map.preferred_username=custom-attribute"})
    class DefaultTests
    extends AbstractOidcTests {
        DefaultTests() {
        }

        @Test
        void verifyTokenGeneration() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("OIDC");
            profile.setId("casuser");
            request.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            List<String> phoneValues = List.of("\\\\123456789", "4805553241");
            Principal principal = RegisteredServiceTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL, List.of("casuser@example.org"), (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER, phoneValues, (String)"color", List.of("yellow"), (String)"custom-attribute", (Object)"test", (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME, List.of("casuser")));
            Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((Principal)principal, (Map)CollectionUtils.wrap((String)"state", List.of("some-state"), (String)"nonce", List.of("some-nonce")));
            MockTicketGrantingTicket tgt = new MockTicketGrantingTicket(authentication);
            String callback = this.casProperties.getServer().getPrefix() + "/oauth2.0/callbackAuthorize.*";
            WebApplicationService service = new WebApplicationServiceFactory().createService(callback);
            tgt.getServices().putAll(CollectionUtils.wrap((String)"service", (Object)service));
            OAuth20AccessToken accessToken = OidcIdTokenGeneratorServiceTests.this.buildAccessToken(tgt);
            OidcRegisteredService registeredService = DefaultTests.getOidcRegisteredService("clientid");
            registeredService.setIdTokenIssuer(UUID.randomUUID().toString());
            registeredService.setScopes(CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.PHONE.getScope()}));
            this.servicesManager.save((RegisteredService)registeredService);
            String idToken = this.oidcIdTokenGenerator.generate(accessToken, (UserProfile)profile, OAuth20ResponseTypes.ID_TOKEN, OAuth20GrantTypes.NONE, (OAuthRegisteredService)registeredService);
            Assertions.assertNotNull((Object)idToken);
            JwtClaims claims = this.oidcTokenSigningAndEncryptionService.decode(idToken, Optional.ofNullable(registeredService));
            Assertions.assertNotNull((Object)claims);
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL));
            Assertions.assertEquals((long)authentication.getAuthenticationDate().toEpochSecond(), (long)((Long)claims.getClaimValue("auth_time")));
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME));
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER));
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PREFERRED_USERNAME));
            Assertions.assertEquals((Object)"casuser@example.org", (Object)claims.getStringClaimValue(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL));
            Assertions.assertEquals((Object)"casuser", (Object)claims.getStringClaimValue(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME));
            Assertions.assertEquals(phoneValues, (Object)claims.getStringListClaimValue(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER));
            Assertions.assertEquals((Object)"test", (Object)claims.getStringClaimValue(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PREFERRED_USERNAME));
            Assertions.assertEquals((Object)registeredService.getIdTokenIssuer(), (Object)claims.getStringClaimValue("iss"));
        }

        @Test
        void verifyTokenGenerationWithoutClaimsForCodeResponseType() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("OIDC");
            profile.setId("casuser");
            request.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            List<String> phoneValues = List.of("123456789", "4805553241");
            Principal principal = RegisteredServiceTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL, List.of("casuser@example.org"), (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER, phoneValues, (String)"color", List.of("yellow"), (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME, List.of("casuser")));
            Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((Principal)principal, (Map)CollectionUtils.wrap((String)"state", List.of("some-state"), (String)"nonce", List.of("some-nonce")));
            MockTicketGrantingTicket tgt = new MockTicketGrantingTicket(authentication);
            String callback = this.casProperties.getServer().getPrefix() + "/oauth2.0/callbackAuthorize.*";
            WebApplicationService service = new WebApplicationServiceFactory().createService(callback);
            tgt.getServices().putAll(CollectionUtils.wrap((String)"service", (Object)service));
            OAuth20AccessToken accessToken = OidcIdTokenGeneratorServiceTests.this.buildAccessToken(tgt);
            OidcRegisteredService registeredService = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"clientid");
            registeredService.setIdTokenExpirationPolicy((RegisteredServiceOidcIdTokenExpirationPolicy)new DefaultRegisteredServiceOidcIdTokenExpirationPolicy("PT60S"));
            registeredService.setScopes(CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.PHONE.getScope()}));
            String idToken = this.oidcIdTokenGenerator.generate(accessToken, (UserProfile)profile, OAuth20ResponseTypes.CODE, OAuth20GrantTypes.NONE, (OAuthRegisteredService)registeredService);
            Assertions.assertNotNull((Object)idToken);
            JwtClaims claims = this.oidcTokenSigningAndEncryptionService.decode(idToken, Optional.of(registeredService));
            Assertions.assertNotNull((Object)claims);
            Assertions.assertFalse((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL));
            Assertions.assertFalse((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME));
            Assertions.assertFalse((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER));
        }

        @Test
        void verifyTokenGenerationWithOutClaimsForAuthzCodeGrantType() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("OIDC");
            profile.setId("casuser");
            request.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            List<String> phoneValues = List.of("123456789", "4805553241");
            Principal principal = RegisteredServiceTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL, List.of("casuser@example.org"), (String)"color", List.of("yellow"), (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER, phoneValues, (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME, List.of("casuser")));
            Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((Principal)principal, (Map)CollectionUtils.wrap((String)"state", List.of("some-state"), (String)"nonce", List.of("some-nonce")));
            MockTicketGrantingTicket tgt = new MockTicketGrantingTicket(authentication);
            String callback = this.casProperties.getServer().getPrefix() + "/oauth2.0/callbackAuthorize.*";
            WebApplicationService service = new WebApplicationServiceFactory().createService(callback);
            tgt.getServices().putAll(CollectionUtils.wrap((String)"service", (Object)service));
            OAuth20AccessToken accessToken = OidcIdTokenGeneratorServiceTests.this.buildAccessToken(tgt);
            OidcRegisteredService registeredService = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"clientid");
            Assertions.assertNotNull((Object)registeredService);
            registeredService.setScopes(CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.PHONE.getScope()}));
            String idToken = this.oidcIdTokenGenerator.generate(accessToken, (UserProfile)profile, OAuth20ResponseTypes.ID_TOKEN, OAuth20GrantTypes.AUTHORIZATION_CODE, (OAuthRegisteredService)registeredService);
            Assertions.assertNotNull((Object)idToken);
            JwtClaims claims = this.oidcTokenSigningAndEncryptionService.decode(idToken, Optional.of(registeredService));
            Assertions.assertNotNull((Object)claims);
            Assertions.assertFalse((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL));
            Assertions.assertFalse((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME));
            Assertions.assertFalse((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER));
        }

        @Test
        void verifyTokenGenerationWithoutCallbackService() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("OIDC");
            profile.setId("casuser");
            request.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            MultifactorAuthenticationProperties mfa = this.casProperties.getAuthn().getMfa();
            Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((String)"casuser", (Map)CollectionUtils.wrap((String)"state", List.of("some-state"), (String)"nonce", List.of("some-nonce"), (String)mfa.getCore().getAuthenticationContextAttribute(), List.of("context-class"), (String)"successfulAuthenticationHandlers", List.of("Handler1")));
            MockTicketGrantingTicket tgt = new MockTicketGrantingTicket(authentication);
            OAuth20AccessToken accessToken = OidcIdTokenGeneratorServiceTests.this.buildAccessToken(tgt);
            String idToken = this.oidcIdTokenGenerator.generate(accessToken, (UserProfile)profile, OAuth20ResponseTypes.CODE, OAuth20GrantTypes.NONE, OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"clientid"));
            Assertions.assertNotNull((Object)idToken);
        }

        @Test
        void verifyUnknownServiceType() {
            Assertions.assertThrows(IllegalArgumentException.class, () -> {
                OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
                this.oidcIdTokenGenerator.generate(accessToken, (UserProfile)new CommonProfile(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.NONE, (OAuthRegisteredService)new MockOAuthRegisteredService());
            });
        }

        @RepeatedTest(value=2)
        public void verifyAccessTokenAsJwt(RepetitionInfo repetitionInfo) throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("OIDC");
            profile.setId("casuser");
            request.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            OAuth20AccessToken accessToken = this.getAccessToken();
            OidcRegisteredService registeredService = DefaultTests.getOidcRegisteredService(accessToken.getClientId());
            registeredService.setJwtAccessToken(true);
            registeredService.setIdTokenSigningAlg("RS256");
            registeredService.setProperties(Map.of(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{"false"}), RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{repetitionInfo.getCurrentRepetition() % 2 == 0 ? "false" : "true"})));
            this.servicesManager.save((RegisteredService)registeredService);
            String idToken = this.oidcIdTokenGenerator.generate(accessToken, (UserProfile)profile, OAuth20ResponseTypes.CODE, OAuth20GrantTypes.NONE, (OAuthRegisteredService)registeredService);
            Assertions.assertNotNull((Object)idToken);
            JwtClaims claims = this.oidcTokenSigningAndEncryptionService.decode(idToken, Optional.of(registeredService));
            Assertions.assertNotNull((Object)claims);
            Assertions.assertTrue((boolean)claims.hasClaim("at_hash"));
            Assertions.assertTrue((boolean)claims.hasClaim("auth_time"));
            String issuer = this.oidcIssuerService.determineIssuer(Optional.of(registeredService));
            Assertions.assertEquals((Object)issuer, (Object)claims.getIssuer());
            String hash = (String)claims.getClaimValue("at_hash", String.class);
            String encodedAccessToken = (String)OAuth20JwtAccessTokenEncoder.builder().accessToken(accessToken).registeredService((RegisteredService)registeredService).service(accessToken.getService()).casProperties(this.casProperties).accessTokenJwtBuilder(this.oidcAccessTokenJwtBuilder).issuer(issuer).build().encode((Object)accessToken.getId());
            String newHash = OAuth20AccessTokenAtHashGenerator.builder().encodedAccessToken(encodedAccessToken).registeredService((RegisteredService)registeredService).algorithm(registeredService.getIdTokenSigningAlg()).build().generate();
            Assertions.assertEquals((Object)hash, (Object)newHash);
        }
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oauth.access-token.crypto.encryption-enabled=false", "cas.authn.oidc.id-token.include-id-token-claims=true"})
    class IgnoringResponseTypeTests
    extends AbstractOidcTests {
        IgnoringResponseTypeTests() {
        }

        @Test
        void verifyTokenGenerationWithClaimsForCodeResponseType() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("OIDC");
            profile.setId("casuser");
            request.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            List<String> phoneValues = List.of("123456789", "4805553241");
            Principal principal = RegisteredServiceTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL, List.of("casuser@example.org"), (String)"color", List.of("yellow"), (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER, phoneValues, (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME, List.of("casuser")));
            Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((Principal)principal, (Map)CollectionUtils.wrap((String)"state", List.of("some-state"), (String)"nonce", List.of("some-nonce")));
            MockTicketGrantingTicket tgt = new MockTicketGrantingTicket(authentication);
            String callback = this.casProperties.getServer().getPrefix() + "/oauth2.0/callbackAuthorize.*";
            WebApplicationService service = new WebApplicationServiceFactory().createService(callback);
            tgt.getServices().putAll(CollectionUtils.wrap((String)"service", (Object)service));
            OAuth20AccessToken accessToken = OidcIdTokenGeneratorServiceTests.this.buildAccessToken(tgt);
            OidcRegisteredService registeredService = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"clientid");
            registeredService.setScopes(CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.PHONE.getScope()}));
            String idToken = this.oidcIdTokenGenerator.generate(accessToken, (UserProfile)profile, OAuth20ResponseTypes.CODE, OAuth20GrantTypes.NONE, (OAuthRegisteredService)registeredService);
            Assertions.assertNotNull((Object)idToken);
            JwtClaims claims = this.oidcTokenSigningAndEncryptionService.decode(idToken, Optional.ofNullable(registeredService));
            Assertions.assertNotNull((Object)claims);
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL));
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME));
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER));
        }
    }

    private static final class MockOAuthRegisteredService
    extends OAuthRegisteredService {
        private static final long serialVersionUID = 8152953800891665827L;

        private MockOAuthRegisteredService() {
        }
    }
}

