/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import java.util.Optional;
import java.util.Set;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.issuer.OidcDefaultIssuerService;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.token.OidcIdTokenSigningAndEncryptionService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
class OidcIdTokenSigningAndEncryptionServiceTests {
    OidcIdTokenSigningAndEncryptionServiceTests() {
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oidc.discovery.id-token-signing-alg-values-supported=RS256,RS384,RS512", "cas.authn.oidc.discovery.id-token-encryption-encoding-values-supported=A128CBC-HS256,A192CBC-HS384,A256CBC-HS512,A128GCM,A192GCM,A256GCM"})
    class DefaultTests
    extends AbstractOidcTests {
        DefaultTests() {
        }

        @Test
        void verifyOperation() {
            JwtClaims claims = this.getClaims();
            String result = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)DefaultTests.getOidcRegisteredService(), claims);
            Assertions.assertNotNull((Object)result);
        }

        @Test
        void verifyWrongType() {
            Assertions.assertFalse((boolean)this.oidcTokenSigningAndEncryptionService.shouldEncryptToken(DefaultTests.getOAuthRegisteredService("1", "http://localhost/cas")));
            Assertions.assertFalse((boolean)this.oidcTokenSigningAndEncryptionService.shouldSignToken(DefaultTests.getOAuthRegisteredService("1", "http://localhost/cas")));
        }

        @Test
        void verifySkipSigning() {
            OidcRegisteredService oidcRegisteredService = DefaultTests.getOidcRegisteredService(false, false);
            boolean result = this.oidcTokenSigningAndEncryptionService.shouldSignToken((OAuthRegisteredService)oidcRegisteredService);
            Assertions.assertFalse((boolean)result);
        }

        @Test
        void verifyValidationOperation() {
            JwtClaims claims = this.getClaims();
            OidcRegisteredService oidcRegisteredService = DefaultTests.getOidcRegisteredService(true, false);
            String result = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
            JwtClaims jwt = this.oidcTokenSigningAndEncryptionService.decode(result, Optional.of(oidcRegisteredService));
            Assertions.assertNotNull((Object)jwt);
        }

        @Test
        void verifyDecodingFailureBadToken() {
            OidcRegisteredService oidcRegisteredService = DefaultTests.getOidcRegisteredService(true, false);
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcTokenSigningAndEncryptionService.decode("bad-token", Optional.of(oidcRegisteredService)));
        }

        @Test
        void verifyDecodingFailureNoIssuer() {
            OidcRegisteredService oidcRegisteredService = DefaultTests.getOidcRegisteredService(true, false);
            JwtClaims claims = this.getClaims();
            claims.setIssuer("");
            String result = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcTokenSigningAndEncryptionService.decode(result, Optional.of(oidcRegisteredService)));
        }

        @Test
        void verifyDecodingFailureBadIssuer() {
            OidcRegisteredService oidcRegisteredService = DefaultTests.getOidcRegisteredService(true, false);
            JwtClaims claims = this.getClaims();
            claims.setIssuer("bad-issuer");
            String result2 = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcTokenSigningAndEncryptionService.decode(result2, Optional.of(oidcRegisteredService)));
        }

        @Test
        void verifyDecodingFailureBadClient() {
            OidcRegisteredService oidcRegisteredService = DefaultTests.getOidcRegisteredService(true, false);
            JwtClaims claims = this.getClaims();
            claims.setStringClaim("client_id", "");
            String result3 = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcTokenSigningAndEncryptionService.decode(result3, Optional.of(oidcRegisteredService)));
        }

        @Test
        void verifyNoneNotSupported() {
            JwtClaims claims = this.getClaims();
            OidcRegisteredService oidcRegisteredService = DefaultTests.getOidcRegisteredService();
            oidcRegisteredService.setIdTokenSigningAlg("none");
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims));
            oidcRegisteredService.setIdTokenSigningAlg("RS256");
            oidcRegisteredService.setIdTokenEncryptionAlg("none");
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims));
        }

        @Test
        void verifyNoneSupported() {
            OidcServerDiscoverySettings discovery = new OidcServerDiscoverySettings(this.casProperties.getAuthn().getOidc().getCore().getIssuer());
            discovery.setIdTokenSigningAlgValuesSupported(Set.of("none"));
            discovery.setIdTokenEncryptionAlgValuesSupported(Set.of("none"));
            OidcIdTokenSigningAndEncryptionService service = new OidcIdTokenSigningAndEncryptionService(this.oidcDefaultJsonWebKeystoreCache, this.oidcServiceJsonWebKeystoreCache, (OidcIssuerService)new OidcDefaultIssuerService(this.casProperties.getAuthn().getOidc()), discovery);
            JwtClaims claims = this.getClaims();
            OidcRegisteredService oidcRegisteredService = DefaultTests.getOidcRegisteredService();
            oidcRegisteredService.setIdTokenSigningAlg("none");
            oidcRegisteredService.setIdTokenEncryptionAlg("none");
            String result = service.encode((OAuthRegisteredService)oidcRegisteredService, claims);
            Assertions.assertNotNull((Object)result);
        }
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oidc.jwks.file-system.jwks-file=classpath:multiple-keys.jwks"})
    class KeystoreWithMultipleKeysTests
    extends AbstractOidcTests {
        KeystoreWithMultipleKeysTests() {
        }

        @Test
        void verifyOperation() {
            JwtClaims claims = this.getClaims();
            OidcRegisteredService es512 = KeystoreWithMultipleKeysTests.getOidcRegisteredService("ES512");
            es512.setIdTokenSigningAlg("ES512");
            es512.setJwksKeyId("EC");
            es512.setEncryptIdToken(false);
            OidcRegisteredService rs256 = KeystoreWithMultipleKeysTests.getOidcRegisteredService("RS256");
            rs256.setIdTokenSigningAlg("RS256");
            rs256.setJwksKeyId("RSA");
            rs256.setEncryptIdToken(false);
            String result1 = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)es512, claims);
            Assertions.assertNotNull((Object)result1);
            String result2 = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)rs256, claims);
            Assertions.assertNotNull((Object)result2);
            String result3 = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)KeystoreWithMultipleKeysTests.getOidcRegisteredService(), claims);
            Assertions.assertNotNull((Object)result3);
        }
    }
}

