/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import java.util.Map;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oauth.access-token.crypto.encryption-enabled=false"})
class OidcJwtAccessTokenEncoderTests
extends AbstractOidcTests {
    OidcJwtAccessTokenEncoderTests() {
    }

    private OAuth20JwtAccessTokenEncoder getAccessTokenEncoder(OAuth20AccessToken accessToken, RegisteredService registeredService) {
        return OAuth20JwtAccessTokenEncoder.builder().accessToken(accessToken).registeredService(registeredService).service(accessToken.getService()).accessTokenJwtBuilder(this.oidcAccessTokenJwtBuilder).casProperties(this.casProperties).build();
    }

    @Test
    void verifyEncodingWithoutEncryptionForService() throws Exception {
        OAuth20AccessToken accessToken = this.getAccessToken();
        OidcRegisteredService registeredService = OidcJwtAccessTokenEncoderTests.getOidcRegisteredService(accessToken.getClientId());
        registeredService.setJwtAccessToken(true);
        registeredService.setProperties(Map.of(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{"false"})));
        this.servicesManager.save((RegisteredService)registeredService);
        String token1 = (String)this.getAccessTokenEncoder(accessToken, (RegisteredService)registeredService).encode((Object)accessToken.getId());
        String token2 = (String)this.getAccessTokenEncoder(accessToken, (RegisteredService)registeredService).encode((Object)accessToken.getId());
        Assertions.assertEquals((Object)token1, (Object)token2);
    }

    @Test
    void verifyExtractionAsParameterForService() throws Exception {
        OAuth20AccessToken accessToken = this.getAccessToken();
        OidcRegisteredService registeredService = this.getRegisteredServiceForJwtAccessTokenWithKeys(accessToken);
        OAuth20JwtAccessTokenEncoder encoder = this.getAccessTokenEncoder(accessToken, (RegisteredService)registeredService);
        String encodedAccessToken = (String)encoder.encode((Object)accessToken.getId());
        String decoded = (String)encoder.decode((Object)encodedAccessToken);
        Assertions.assertNotNull((Object)decoded);
        Assertions.assertEquals((Object)accessToken.getId(), (Object)decoded);
    }

    @Test
    void verifyEncodingWithNoCiphersForService() throws Exception {
        OAuth20AccessToken accessToken = this.getAccessToken("", "encoding-service-clientid");
        OidcRegisteredService registeredService = this.getRegisteredServiceForJwtAccessTokenWithKeys(accessToken);
        OAuth20JwtAccessTokenEncoder encoder = this.getAccessTokenEncoder(accessToken, (RegisteredService)registeredService);
        String token1 = (String)encoder.encode((Object)accessToken.getId());
        String token2 = (String)encoder.encode((Object)accessToken.getId());
        Assertions.assertEquals((Object)token1, (Object)token2);
        String decoded1 = (String)encoder.decode((Object)token1);
        String decoded2 = (String)encoder.decode((Object)token2);
        Assertions.assertEquals((Object)decoded1, (Object)decoded2);
        Assertions.assertEquals((Object)accessToken.getId(), (Object)decoded1);
    }

    private OidcRegisteredService getRegisteredServiceForJwtAccessTokenWithKeys(OAuth20AccessToken accessToken) {
        OidcRegisteredService registeredService = OidcJwtAccessTokenEncoderTests.getOidcRegisteredService(accessToken.getClientId());
        registeredService.setJwtAccessToken(true);
        DefaultRegisteredServiceProperty property = new DefaultRegisteredServiceProperty(new String[]{"false"});
        registeredService.setProperties(Map.of(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED.getPropertyName(), property, RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_ENABLED.getPropertyName(), property));
        this.servicesManager.save((RegisteredService)registeredService);
        return registeredService;
    }
}

