/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.token.OidcRegisteredServiceJwtAccessTokenCipherExecutor;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.token.cipher.JwtTicketCipherExecutor;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="OIDC")
class OidcRegisteredServiceJwtAccessTokenCipherExecutorNoCacheTests
extends AbstractOidcTests {
    OidcRegisteredServiceJwtAccessTokenCipherExecutorNoCacheTests() {
    }

    @Test
    void verifyEmptyCacheOperation() {
        String id = UUID.randomUUID().toString();
        LoadingCache defaultCache = (LoadingCache)Mockito.mock(LoadingCache.class);
        Mockito.when((Object)defaultCache.get(Mockito.any())).thenReturn(Optional.empty());
        LoadingCache serviceCache = (LoadingCache)Mockito.mock(LoadingCache.class);
        Mockito.when((Object)serviceCache.get(Mockito.any())).thenReturn(Optional.empty());
        OidcRegisteredServiceJwtAccessTokenCipherExecutor cipher = new OidcRegisteredServiceJwtAccessTokenCipherExecutor(defaultCache, serviceCache, OidcIssuerService.echoing((String)id));
        OidcRegisteredService service = OidcRegisteredServiceJwtAccessTokenCipherExecutorNoCacheTests.getOidcRegisteredService("whatever");
        Assertions.assertTrue((boolean)cipher.getSigningKey((RegisteredService)service).isEmpty());
        service.getProperties().put(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{"true"}));
        Assertions.assertTrue((boolean)cipher.getEncryptionKey((RegisteredService)service).isEmpty());
        Mockito.when((Object)serviceCache.get(Mockito.any())).thenReturn(Optional.of(new JsonWebKeySet(new JsonWebKey[]{(JsonWebKey)Mockito.mock(PublicJsonWebKey.class)})));
        Assertions.assertTrue((boolean)cipher.getEncryptionKey((RegisteredService)service).isEmpty());
    }

    @Test
    void verifyCipherOperation() {
        String id = UUID.randomUUID().toString();
        LoadingCache defaultCache = (LoadingCache)Mockito.mock(LoadingCache.class);
        Mockito.when((Object)defaultCache.get(Mockito.any())).thenReturn(Optional.empty());
        LoadingCache serviceCache = (LoadingCache)Mockito.mock(LoadingCache.class);
        Mockito.when((Object)serviceCache.get(Mockito.any())).thenReturn(Optional.empty());
        OidcRegisteredServiceJwtAccessTokenCipherExecutor cipher = new OidcRegisteredServiceJwtAccessTokenCipherExecutor(defaultCache, serviceCache, OidcIssuerService.echoing((String)id));
        OidcRegisteredService service = OidcRegisteredServiceJwtAccessTokenCipherExecutorNoCacheTests.getOidcRegisteredService("whatever");
        JwtTicketCipherExecutor exec = cipher.createCipherExecutorInstance(null, null, (RegisteredService)service);
        Assertions.assertEquals((Object)"value", (Object)exec.decode((Serializable)((Object)"value"), new Object[]{service}));
        Mockito.when((Object)serviceCache.get(Mockito.any())).thenReturn(Optional.of(new JsonWebKeySet(new JsonWebKey[]{(JsonWebKey)Mockito.mock(PublicJsonWebKey.class)})));
        Assertions.assertEquals((Object)"value", (Object)exec.decode((Serializable)((Object)"value"), new Object[]{service}));
    }
}

