/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.issuer.OidcDefaultIssuerService;
import org.apereo.cas.oidc.util.OidcRequestSupport;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.BasicUserProfile;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class OidcRequestSupportTests
extends AbstractOidcTests {
    OidcRequestSupportTests() {
    }

    protected static JEEContext getContextForEndpoint(String endpoint) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.setServerName("sso.example.org");
        request.setServerPort(8443);
        request.setRequestURI("/cas/oidc/" + endpoint);
        MockHttpServletResponse response = new MockHttpServletResponse();
        return new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
    }

    @Test
    void verifyRemovePrompt() {
        String url = "https://tralala.whapi.com/something?prompt=consent";
        String request = OidcRequestSupport.removeOidcPromptFromAuthorizationRequest((String)"https://tralala.whapi.com/something?prompt=consent", (String)"consent");
        Assertions.assertFalse((boolean)request.contains("prompt"));
    }

    @Test
    void verifyOidcPrompt() {
        String url = "https://tralala.whapi.com/something?prompt=login";
        Set authorizationRequest = this.oauthRequestParameterResolver.resolveSupportedPromptValues("https://tralala.whapi.com/something?prompt=login");
        Assertions.assertEquals((Object)"login", (Object)authorizationRequest.toArray()[0]);
    }

    @Test
    void verifyOidcPromptFromContext() {
        String url = "https://tralala.whapi.com/something?prompt=login";
        WebContext context = (WebContext)Mockito.mock(WebContext.class);
        Mockito.when((Object)context.getFullRequestURL()).thenReturn((Object)"https://tralala.whapi.com/something?prompt=login");
        Set authorizationRequest = this.oauthRequestParameterResolver.resolveSupportedPromptValues(context);
        Assertions.assertEquals((Object)"login", (Object)authorizationRequest.toArray()[0]);
    }

    @Test
    void verifyOidcMaxAgeTooOld() {
        WebContext context = (WebContext)Mockito.mock(WebContext.class);
        Mockito.when((Object)context.getFullRequestURL()).thenReturn((Object)"https://tralala.whapi.com/something?max_age=1");
        ZonedDateTime authenticationDate = ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(5L);
        Assertions.assertTrue((boolean)OidcRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest((WebContext)context, (ZonedDateTime)authenticationDate));
        Authentication authn = CoreAuthenticationTestUtils.getAuthentication((String)"casuser", (ZonedDateTime)authenticationDate);
        Assertions.assertTrue((boolean)OidcRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest((WebContext)context, (Authentication)authn));
        CommonProfile profile = new CommonProfile();
        profile.setClientName("OIDC");
        profile.setId("casuser");
        profile.addAuthenticationAttribute("authenticationDate", (Object)authenticationDate);
        Assertions.assertTrue((boolean)OidcRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest((WebContext)context, (BasicUserProfile)profile));
    }

    @Test
    void verifyOidcMaxAgeTooOldForContext() {
        ZonedDateTime authenticationDate = ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(5L);
        Authentication authn = CoreAuthenticationTestUtils.getAuthentication((String)"casuser", (ZonedDateTime)authenticationDate);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("https://tralala.whapi.com/something?max_age=1");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        CasCookieBuilder builder = (CasCookieBuilder)Mockito.mock(CasCookieBuilder.class);
        Mockito.when((Object)builder.retrieveCookieValue((HttpServletRequest)Mockito.any())).thenReturn((Object)UUID.randomUUID().toString());
        TicketRegistrySupport registrySupport = (TicketRegistrySupport)Mockito.mock(TicketRegistrySupport.class);
        Mockito.when((Object)registrySupport.getAuthenticationFrom(Mockito.anyString())).thenReturn((Object)authn);
        OidcRequestSupport support = new OidcRequestSupport(builder, registrySupport);
        Assertions.assertTrue((boolean)support.isCasAuthenticationOldForMaxAgeAuthorizationRequest((WebContext)context));
    }

    @Test
    void verifyOidcMaxAge() {
        WebContext context = (WebContext)Mockito.mock(WebContext.class);
        Mockito.when((Object)context.getFullRequestURL()).thenReturn((Object)"https://tralala.whapi.com/something?max_age=1000");
        Optional age = OidcRequestSupport.getOidcMaxAgeFromAuthorizationRequest((WebContext)context);
        Assertions.assertTrue((boolean)age.isPresent());
        Assertions.assertEquals((long)1000L, (long)((Long)age.get()));
        Mockito.when((Object)context.getFullRequestURL()).thenReturn((Object)"https://tralala.whapi.com/something?max_age=NA");
        Optional age2 = OidcRequestSupport.getOidcMaxAgeFromAuthorizationRequest((WebContext)context);
        Assertions.assertTrue((boolean)age2.isPresent());
        Assertions.assertEquals((long)-1L, (long)((Long)age2.get()));
        Mockito.when((Object)context.getFullRequestURL()).thenReturn((Object)"https://tralala.whapi.com/something?");
        Optional age3 = OidcRequestSupport.getOidcMaxAgeFromAuthorizationRequest((WebContext)context);
        Assertions.assertFalse((boolean)age3.isPresent());
    }

    @Test
    void verifyAuthnProfile() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("https://www.example.org");
        request.setQueryString("param=value");
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        CommonProfile profile = new CommonProfile();
        context.setRequestAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        Assertions.assertTrue((boolean)OidcRequestSupport.isAuthenticationProfileAvailable((JEEContext)context, (SessionStore)JEESessionStore.INSTANCE).isPresent());
    }

    @Test
    void verifyGetRedirectUrlWithError() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.setServerName("example.org");
        request.addParameter("state", "123456");
        request.setServerPort(443);
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        String expectedUrlWithError = context.getRequestURL() + "?error=login_required&state=123456";
        Assertions.assertEquals((Object)expectedUrlWithError, (Object)OidcRequestSupport.getRedirectUrlWithError((String)context.getRequestURL(), (String)"login_required", (WebContext)context));
    }

    @Test
    void validateStaticIssuer() {
        String staticIssuer = "https://sso.example.org:8443/cas/oidc";
        OidcProperties properties = new CasConfigurationProperties().getAuthn().getOidc();
        properties.getCore().setIssuer("https://sso.example.org:8443/cas/oidc");
        OidcDefaultIssuerService issuerService = new OidcDefaultIssuerService(properties);
        Assertions.assertTrue((boolean)issuerService.validateIssuer((WebContext)OidcRequestSupportTests.getContextForEndpoint("authorize"), "authorize"));
        Assertions.assertTrue((boolean)issuerService.validateIssuer((WebContext)OidcRequestSupportTests.getContextForEndpoint("profile"), "profile"));
        Assertions.assertTrue((boolean)issuerService.validateIssuer((WebContext)OidcRequestSupportTests.getContextForEndpoint("logout"), "logout"));
        Assertions.assertTrue((boolean)issuerService.validateIssuer((WebContext)OidcRequestSupportTests.getContextForEndpoint("realms/authorize"), "authorize"));
    }

    @Test
    void validateDynamicIssuer() {
        String staticIssuer = "https://sso.example.org:8443/cas/oidc/custom/fawnoos/issuer";
        OidcProperties properties = new CasConfigurationProperties().getAuthn().getOidc();
        properties.getCore().setIssuer("https://sso.example.org:8443/cas/oidc/custom/fawnoos/issuer");
        OidcDefaultIssuerService issuerService = new OidcDefaultIssuerService(properties);
        Assertions.assertTrue((boolean)issuerService.validateIssuer((WebContext)OidcRequestSupportTests.getContextForEndpoint("custom/fawnoos/issuer/authorize"), "authorize"));
        Assertions.assertTrue((boolean)issuerService.validateIssuer((WebContext)OidcRequestSupportTests.getContextForEndpoint("custom/fawnoos/issuer/profile"), "profile"));
        Assertions.assertTrue((boolean)issuerService.validateIssuer((WebContext)OidcRequestSupportTests.getContextForEndpoint("custom/fawnoos/issuer/oidcAuthorize"), "oidcAuthorize"));
        Assertions.assertTrue((boolean)issuerService.validateIssuer((WebContext)OidcRequestSupportTests.getContextForEndpoint("custom/fawnoos/issuer"), "unknown"));
    }

    @Test
    void validateDynamicIssuerForLogout() {
        String staticIssuer = "https://sso.example.org:8443/cas/oidc";
        OidcProperties properties = new CasConfigurationProperties().getAuthn().getOidc();
        properties.getCore().setIssuer("https://sso.example.org:8443/cas/oidc");
        OidcDefaultIssuerService issuerService = new OidcDefaultIssuerService(properties);
        Assertions.assertTrue((boolean)issuerService.validateIssuer((WebContext)OidcRequestSupportTests.getContextForEndpoint("logout"), "oidcLogout"));
    }

    @Test
    void validateIssuerMismatch() {
        String staticIssuer = "https://sso.example.org:8443/cas/openid-connect";
        OidcProperties properties = new CasConfigurationProperties().getAuthn().getOidc();
        properties.getCore().setIssuer("https://sso.example.org:8443/cas/openid-connect");
        OidcDefaultIssuerService issuerService = new OidcDefaultIssuerService(properties);
        Assertions.assertFalse((boolean)issuerService.validateIssuer((WebContext)OidcRequestSupportTests.getContextForEndpoint("logout"), "oidcLogout"));
    }
}

