/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.token.JwtBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class DefaultOAuth20RequestParameterResolverTests
extends AbstractOidcTests {
    DefaultOAuth20RequestParameterResolverTests() {
    }

    @Test
    void verifySignedJwtWithClientId() {
        OidcRegisteredService registeredService = DefaultOAuth20RequestParameterResolverTests.getOidcRegisteredService("client");
        this.servicesManager.save((RegisteredService)registeredService);
        JwtBuilder.JwtRequest payload = JwtBuilder.JwtRequest.builder().registeredService(Optional.of(registeredService)).serviceAudience(Set.of(UUID.randomUUID().toString())).issuer("https://cas.example.org").jwtId(UUID.randomUUID().toString()).subject("casuser").issueDate(new Date()).attributes(Map.of("scope", List.of("openid"), "redirect_uri", List.of("https://apereo.github.io"), "response_type", List.of("code"), "client_id", List.of(registeredService.getClientId()))).build();
        String jwtString = this.oidcAccessTokenJwtBuilder.build(payload);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("request", jwtString);
        request.addParameter("client_id", registeredService.getClientId());
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Optional scope = this.oauthRequestParameterResolver.resolveRequestParameter((WebContext)context, "scope", String.class);
        Assertions.assertFalse((boolean)scope.isEmpty());
        Assertions.assertTrue((boolean)((String)scope.get()).contains("openid"));
    }
}

