/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.ui.ModelMap;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
class OidcAccessTokenResponseGeneratorTests
extends AbstractOidcTests {
    OidcAccessTokenResponseGeneratorTests() {
    }

    @Test
    void verifyAccessTokenResponseAsCode() throws Exception {
        OAuth20TokenGeneratedResult token = OAuth20TokenGeneratedResult.builder().accessToken(this.getAccessToken()).refreshToken(OidcAccessTokenResponseGeneratorTests.getRefreshToken()).registeredService((RegisteredService)OidcAccessTokenResponseGeneratorTests.getOidcRegisteredService()).responseType(OAuth20ResponseTypes.CODE).build();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = new ProfileManager((WebContext)context, JEESessionStore.INSTANCE);
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("casuser");
        manager.save(true, (UserProfile)profile, false);
        OAuth20AccessTokenResponseResult result = OAuth20AccessTokenResponseResult.builder().service((Service)RegisteredServiceTestUtils.getService()).registeredService((RegisteredService)OidcAccessTokenResponseGeneratorTests.getOidcRegisteredService()).casProperties(this.casProperties).generatedToken(token).userProfile((UserProfile)profile).build();
        ModelAndView mv = this.oidcAccessTokenResponseGenerator.generate(result);
        Assertions.assertNotNull((Object)mv);
        ModelMap modelMap = mv.getModelMap();
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"access_token"));
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"scope"));
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"expires_in"));
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"token_type"));
    }

    @Test
    void verifyAccessTokenResponseForDeviceCode() {
        OAuth20DeviceToken devCode = this.deviceTokenFactory.createDeviceCode((Service)RegisteredServiceTestUtils.getService());
        OAuth20TokenGeneratedResult token = OAuth20TokenGeneratedResult.builder().registeredService((RegisteredService)OidcAccessTokenResponseGeneratorTests.getOidcRegisteredService()).responseType(OAuth20ResponseTypes.DEVICE_CODE).deviceCode(devCode.getId()).userCode(this.deviceUserCodeFactory.createDeviceUserCode(devCode).getId()).build();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = new ProfileManager((WebContext)context, JEESessionStore.INSTANCE);
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("casuser");
        manager.save(true, (UserProfile)profile, false);
        OAuth20AccessTokenResponseResult result = OAuth20AccessTokenResponseResult.builder().service((Service)RegisteredServiceTestUtils.getService()).registeredService((RegisteredService)OidcAccessTokenResponseGeneratorTests.getOidcRegisteredService()).casProperties(this.casProperties).generatedToken(token).responseType(OAuth20ResponseTypes.DEVICE_CODE).userProfile((UserProfile)profile).build();
        ModelAndView mv = this.oidcAccessTokenResponseGenerator.generate(result);
        Assertions.assertNotNull((Object)mv);
        ModelMap modelMap = mv.getModelMap();
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"verification_uri"));
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"user_code"));
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"device_code"));
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"interval"));
    }
}

