/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.List;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.OidcAuthenticationAuthorizeSecurityLogic;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.BasicUserProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class OidcAuthenticationAuthorizeSecurityLogicTests
extends AbstractOidcTests {
    private TicketGrantingTicket ticketGrantingTicket;

    OidcAuthenticationAuthorizeSecurityLogicTests() {
    }

    @Override
    @BeforeEach
    public void initialize() throws Exception {
        super.initialize();
        this.ticketGrantingTicketCookieGenerator = (CasCookieBuilder)Mockito.mock(CasCookieBuilder.class);
        this.ticketGrantingTicket = new MockTicketGrantingTicket("casuser");
        this.ticketRegistry.addTicket((Ticket)this.ticketGrantingTicket);
    }

    @Test
    void verifyOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Mockito.when((Object)this.ticketGrantingTicketCookieGenerator.retrieveCookieValue((HttpServletRequest)request)).thenReturn((Object)this.ticketGrantingTicket.getId());
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager profileManager = new ProfileManager((WebContext)context, JEESessionStore.INSTANCE);
        profileManager.save(true, (UserProfile)new BasicUserProfile(), false);
        OidcAuthenticationAuthorizeSecurityLogic logic = new OidcAuthenticationAuthorizeSecurityLogic(this.ticketGrantingTicketCookieGenerator, this.ticketRegistry, this.oauthRequestParameterResolver);
        Assertions.assertFalse((boolean)logic.loadProfiles(new CallContext((WebContext)context, JEESessionStore.INSTANCE), profileManager, List.of()).isEmpty());
        request.setQueryString("prompt=login");
        Assertions.assertTrue((boolean)logic.loadProfiles(new CallContext((WebContext)context, JEESessionStore.INSTANCE), profileManager, List.of()).isEmpty());
    }

    @Test
    void verifyMaxAgeOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("max_age", "5");
        MockHttpServletResponse response = new MockHttpServletResponse();
        Mockito.when((Object)this.ticketGrantingTicketCookieGenerator.retrieveCookieValue((HttpServletRequest)request)).thenReturn((Object)this.ticketGrantingTicket.getId());
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager profileManager = new ProfileManager((WebContext)context, JEESessionStore.INSTANCE);
        BasicUserProfile profile = new BasicUserProfile();
        profile.addAuthenticationAttribute("authenticationDate", (Object)ZonedDateTime.now(Clock.systemUTC()).minusSeconds(30L));
        profileManager.save(true, (UserProfile)profile, false);
        OidcAuthenticationAuthorizeSecurityLogic logic = new OidcAuthenticationAuthorizeSecurityLogic(this.ticketGrantingTicketCookieGenerator, this.ticketRegistry, this.oauthRequestParameterResolver);
        Assertions.assertTrue((boolean)logic.loadProfiles(new CallContext((WebContext)context, JEESessionStore.INSTANCE), profileManager, List.of()).isEmpty());
    }

    @Test
    void verifyLoadNoProfileWhenNoTgtAvailable() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager profileManager = new ProfileManager((WebContext)context, JEESessionStore.INSTANCE);
        profileManager.save(true, (UserProfile)new BasicUserProfile(), false);
        OidcAuthenticationAuthorizeSecurityLogic logic = new OidcAuthenticationAuthorizeSecurityLogic(this.ticketGrantingTicketCookieGenerator, this.ticketRegistry, this.oauthRequestParameterResolver);
        Assertions.assertTrue((boolean)logic.loadProfiles(new CallContext((WebContext)context, JEESessionStore.INSTANCE), profileManager, List.of()).isEmpty());
    }
}

