/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.discovery.authorization-response-issuer-parameter-supported=true"})
class OidcAuthorizationModelAndViewBuilderTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oauthAuthorizationModelAndViewBuilder")
    private OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder;

    OidcAuthorizationModelAndViewBuilderTests() {
    }

    @Test
    void verifyOperationForOidc() throws Exception {
        HashMap parameters = new HashMap();
        OidcRegisteredService registeredService = OidcAuthorizationModelAndViewBuilderTests.getOidcRegisteredService();
        ModelAndView results = this.oauthAuthorizationModelAndViewBuilder.build((OAuthRegisteredService)registeredService, OAuth20ResponseModeTypes.FORM_POST, "https://localhost:8443/app/redirect", parameters);
        Assertions.assertTrue((boolean)results.getModel().containsKey("originalUrl"));
        String url = results.getModel().get("originalUrl").toString();
        Assertions.assertTrue((boolean)url.contains("iss".concat("=")));
        Map params = (Map)results.getModel().get("parameters");
        Assertions.assertTrue((boolean)params.containsKey("iss"));
    }

    @Test
    void verifyOperationForNonOidc() throws Exception {
        HashMap parameters = new HashMap();
        OAuthRegisteredService registeredService = OidcAuthorizationModelAndViewBuilderTests.getOAuthRegisteredService(UUID.randomUUID().toString(), "https://localhost:8443/app/redirect");
        ModelAndView results = this.oauthAuthorizationModelAndViewBuilder.build(registeredService, OAuth20ResponseModeTypes.NONE, "https://localhost:8443/app/redirect", parameters);
        RedirectView view = (RedirectView)results.getView();
        Assertions.assertEquals((Object)"https://localhost:8443/app/redirect", (Object)Objects.requireNonNull(view).getUrl());
    }
}

