/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OIDC")
class OidcCallbackAuthorizeViewResolverTests
extends AbstractOidcTests {
    OidcCallbackAuthorizeViewResolverTests() {
    }

    @Test
    void verifyRedirect() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = new ProfileManager((WebContext)context, JEESessionStore.INSTANCE);
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("casuser");
        manager.save(true, (UserProfile)profile, false);
        ModelAndView mv = this.callbackAuthorizeViewResolver.resolve((WebContext)context, manager, "https://github.com");
        Assertions.assertNotNull((Object)mv);
        Assertions.assertTrue((boolean)(mv.getView() instanceof RedirectView));
    }

    @Test
    void verifyPromptNoneWithProfile() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        String url = "https://cas.org/something?prompt=none";
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = new ProfileManager((WebContext)context, JEESessionStore.INSTANCE);
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("casuser");
        manager.save(true, (UserProfile)profile, false);
        ModelAndView mv = this.callbackAuthorizeViewResolver.resolve((WebContext)context, manager, "https://cas.org/something?prompt=none");
        Assertions.assertNotNull((Object)mv);
        Assertions.assertTrue((boolean)(mv.getView() instanceof RedirectView));
    }

    @Test
    void verifyPromptNoneWithoutProfile() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        String url = "https://cas.org/something?prompt=none";
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = new ProfileManager((WebContext)context, JEESessionStore.INSTANCE);
        ModelAndView mv = this.callbackAuthorizeViewResolver.resolve((WebContext)context, manager, "https://cas.org/something?prompt=none");
        Assertions.assertNotNull((Object)mv);
        Assertions.assertEquals((Object)"login_required", mv.getModel().get("error"));
    }

    @Test
    void verifyPromptNoneWithoutProfileWithPostResponseMode() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        request.addParameter("redirect_uri", "https://google.com");
        request.addParameter("state", "randomState");
        request.addParameter("nonce", "nonce");
        request.addParameter("response_mode", OAuth20ResponseModeTypes.FORM_POST.getType());
        request.addParameter("prompt", "none");
        ProfileManager manager = new ProfileManager((WebContext)context, JEESessionStore.INSTANCE);
        URIBuilder builder = new URIBuilder();
        request.getParameterMap().forEach((key, values) -> builder.addParameter(key, values[0]));
        request.setQueryString(builder.build().getQuery());
        String url = context.getFullRequestURL();
        ModelAndView mv = this.callbackAuthorizeViewResolver.resolve((WebContext)context, manager, url);
        Assertions.assertNotNull((Object)mv);
        Assertions.assertEquals((Object)"casPostResponseView", (Object)mv.getViewName());
        Assertions.assertTrue((boolean)mv.getModel().containsKey("originalUrl"));
        Map parameters = (Map)mv.getModel().get("parameters");
        Assertions.assertEquals((Object)request.getParameter("state"), parameters.get("state"));
        Assertions.assertFalse((boolean)parameters.containsKey("nonce"));
    }

    @Test
    void verifyPromptNoneWithoutProfileWithRedirectParam() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("redirect_uri", "https://google.com");
        String url = "https://cas.org/something?prompt=none";
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = new ProfileManager((WebContext)context, JEESessionStore.INSTANCE);
        ModelAndView mv = this.callbackAuthorizeViewResolver.resolve((WebContext)context, manager, "https://cas.org/something?prompt=none");
        Assertions.assertNotNull((Object)mv);
        Assertions.assertEquals((Object)"login_required", mv.getModel().get("error"));
    }

    @Test
    void verifyPromptLogin() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        String url = "https://cas.org/something?prompt=login";
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = new ProfileManager((WebContext)context, JEESessionStore.INSTANCE);
        ModelAndView mv = this.callbackAuthorizeViewResolver.resolve((WebContext)context, manager, "https://cas.org/something?prompt=login");
        Assertions.assertNotNull((Object)mv);
        Assertions.assertTrue((boolean)(mv.getView() instanceof RedirectView));
    }
}

