/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.jee.context.JEEContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class OidcCasClientRedirectActionBuilderTests
extends AbstractOidcTests {
    OidcCasClientRedirectActionBuilderTests() {
    }

    @Test
    void verifyPromptNone() {
        this.verifyBuild("=none");
    }

    @Test
    void verifyPromptLogin() {
        this.verifyBuild("=login");
    }

    private void verifyBuild(String prompt) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("https://cas.org/something");
        request.setQueryString("prompt" + prompt);
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        CasClient casClient = new CasClient(new CasConfiguration("https://caslogin.com"));
        casClient.setCallbackUrl("https://caslogin.com");
        CallbackUrlResolver callback = (CallbackUrlResolver)Mockito.mock(CallbackUrlResolver.class);
        Mockito.when((Object)callback.compute((UrlResolver)Mockito.any(), (String)Mockito.any(), Mockito.anyString(), (WebContext)Mockito.any())).thenReturn((Object)"https://caslogin.com");
        casClient.setCallbackUrlResolver(callback);
        casClient.setUrlResolver((UrlResolver)Mockito.mock(UrlResolver.class));
        Optional result = this.oauthCasClientRedirectActionBuilder.build(casClient, (WebContext)context);
        Assertions.assertTrue((boolean)result.isPresent());
    }
}

