/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Tag(value="OIDC")
class OidcClientSecretValidatorTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oauth20ClientSecretValidator")
    private OAuth20ClientSecretValidator oauth20ClientSecretValidator;

    OidcClientSecretValidatorTests() {
    }

    @Test
    void verifyNotExpired() {
        String secret = UUID.randomUUID().toString();
        OidcRegisteredService service = OidcClientSecretValidatorTests.getOidcRegisteredService();
        service.setClientSecret(secret);
        service.setClientSecretExpiration(ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(1L).toEpochSecond());
        boolean results = this.oauth20ClientSecretValidator.validate((OAuthRegisteredService)service, secret);
        Assertions.assertTrue((boolean)results);
    }

    @Test
    void verifyExpired() {
        String secret = UUID.randomUUID().toString();
        OidcRegisteredService service = OidcClientSecretValidatorTests.getOidcRegisteredService();
        service.setClientSecret(secret);
        service.setClientSecretExpiration(ZonedDateTime.now(ZoneOffset.UTC).minusHours(1L).toEpochSecond());
        boolean results = this.oauth20ClientSecretValidator.validate((OAuthRegisteredService)service, secret);
        Assertions.assertFalse((boolean)results);
    }
}

