/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.UUID;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequest;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestFactory;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
class OidcConsentApprovalViewResolverTests
extends AbstractOidcTests {
    OidcConsentApprovalViewResolverTests() {
    }

    @Test
    void verifyBypassedBySession() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("user-agent", (Object)"MSIE");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        this.oauthDistributedSessionStore.set((WebContext)context, "bypass_approval_prompt", (Object)"true");
        OAuthRegisteredService service = OidcConsentApprovalViewResolverTests.getOAuthRegisteredService(UUID.randomUUID().toString(), "https://google.com");
        Assertions.assertFalse((boolean)this.consentApprovalViewResolver.resolve((WebContext)context, service).hasView());
    }

    @Test
    void verifyBypassedByPrompt() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("https://cas.org/something");
        request.addHeader("user-agent", (Object)"MSIE");
        request.setQueryString("prompt=consent");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        OidcRegisteredService service = OidcConsentApprovalViewResolverTests.getOidcRegisteredService(UUID.randomUUID().toString());
        ModelAndView mv = this.consentApprovalViewResolver.resolve((WebContext)context, (OAuthRegisteredService)service);
        Assertions.assertTrue((boolean)mv.hasView());
    }

    @Test
    void verifyBypassedForPushAuthz() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("user-agent", (Object)"MSIE");
        request.setRequestURI("https://cas.org/something/oidcPushAuthorize");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        OidcRegisteredService service = OidcConsentApprovalViewResolverTests.getOidcRegisteredService(UUID.randomUUID().toString());
        ModelAndView mv = this.consentApprovalViewResolver.resolve((WebContext)context, (OAuthRegisteredService)service);
        Assertions.assertFalse((boolean)mv.hasView());
    }

    @Test
    void verifyPushedAuthz() throws Exception {
        OidcRegisteredService registeredService = OidcConsentApprovalViewResolverTests.getOidcRegisteredService();
        CommonProfile profile = new CommonProfile();
        profile.setId("casTest");
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().clientId(registeredService.getClientId()).service((Service)RegisteredServiceTestUtils.getService()).authentication(RegisteredServiceTestUtils.getAuthentication()).registeredService((OAuthRegisteredService)registeredService).grantType(OAuth20GrantTypes.AUTHORIZATION_CODE).responseType(OAuth20ResponseTypes.CODE).userProfile((UserProfile)profile).scopes(CollectionUtils.wrapSet((Object[])new String[]{"email", "profile"})).build();
        OidcPushedAuthorizationRequestFactory factory = (OidcPushedAuthorizationRequestFactory)this.defaultTicketFactory.get(OidcPushedAuthorizationRequest.class);
        OidcPushedAuthorizationRequest ticket = factory.create(holder);
        this.ticketRegistry.addTicket((Ticket)ticket);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("https://cas.org/something/oidcAuthorize");
        request.addHeader("user-agent", (Object)"MSIE");
        request.addParameter("request_uri", ticket.getId());
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        OidcRegisteredService service = OidcConsentApprovalViewResolverTests.getOidcRegisteredService(UUID.randomUUID().toString());
        ModelAndView mv = this.consentApprovalViewResolver.resolve((WebContext)context, (OAuthRegisteredService)service);
        Assertions.assertTrue((boolean)mv.hasView());
        Assertions.assertEquals((int)3, (int)((Collection)mv.getModel().get("scopes")).size());
    }

    @Test
    void verifyBypassedWithoutPrompt() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("user-agent", (Object)"MSIE");
        request.setRequestURI("https://cas.org/something");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        OidcRegisteredService service = OidcConsentApprovalViewResolverTests.getOidcRegisteredService(UUID.randomUUID().toString());
        service.markAsDynamicallyRegistered();
        ModelAndView mv = this.consentApprovalViewResolver.resolve((WebContext)context, (OAuthRegisteredService)service);
        Assertions.assertTrue((boolean)mv.hasView());
        Assertions.assertTrue((boolean)mv.getModel().containsKey("dynamic"));
        Assertions.assertTrue((boolean)mv.getModel().containsKey("dynamicTime"));
    }
}

