/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
class OidcHandlerInterceptorAdapterTests {
    OidcHandlerInterceptorAdapterTests() {
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oidc.registration.dynamic-client-registration-mode=PROTECTED"})
    class DefaultTests
    extends AbstractOidcTests {
        DefaultTests() {
        }

        @Test
        void verifyNothing() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addHeader("user-agent", (Object)"MSIE");
            MockHttpServletResponse response = new MockHttpServletResponse();
            Assertions.assertTrue((boolean)this.oauthInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
        }

        @Test
        void verifyNoOIDC() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addHeader("user-agent", (Object)"MSIE");
            request.setRequestURI("/device");
            MockHttpServletResponse response = new MockHttpServletResponse();
            Assertions.assertFalse((boolean)this.oauthInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
        }

        @Test
        void verifyConfigUrl() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addHeader("user-agent", (Object)"MSIE");
            request.setRequestURI("/clientConfig");
            MockHttpServletResponse response = new MockHttpServletResponse();
            Assertions.assertFalse((boolean)this.oauthInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
        }

        @Test
        void verifyRegUrl() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addHeader("user-agent", (Object)"MSIE");
            request.setRequestURI("/register");
            MockHttpServletResponse response = new MockHttpServletResponse();
            Assertions.assertFalse((boolean)this.oauthInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
        }

        @Test
        void verifyPushAuthzUrl() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addHeader("user-agent", (Object)"MSIE");
            request.setRequestURI("/oidcPushAuthorize");
            MockHttpServletResponse response = new MockHttpServletResponse();
            Assertions.assertFalse((boolean)this.oauthInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
        }
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oidc.discovery.require-pushed-authorization-requests=true"})
    class PushedAuthorizationTests
    extends AbstractOidcTests {
        PushedAuthorizationTests() {
        }

        @Test
        void verifyAuthzUrl() throws Exception {
            OAuthRegisteredService svc = PushedAuthorizationTests.getOAuthRegisteredService(UUID.randomUUID().toString(), "https://oauth.example.org");
            this.servicesManager.save((RegisteredService)svc);
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.setRequestURI("/oidcAuthorize");
            request.addParameter("client_id", svc.getClientId());
            request.addParameter("redirect_uri", svc.getServiceId());
            request.addParameter("response_type", OAuth20ResponseTypes.CODE.getType());
            request.addHeader("user-agent", (Object)"MSIE");
            request.setMethod(HttpMethod.GET.name());
            MockHttpServletResponse response = new MockHttpServletResponse();
            Assertions.assertFalse((boolean)this.oauthInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
            Assertions.assertEquals((int)HttpStatus.FORBIDDEN.value(), (int)response.getStatus());
        }
    }
}

