/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
class OidcImplicitIdTokenAndTokenAuthorizationResponseBuilderTests
extends AbstractOidcTests {
    OidcImplicitIdTokenAndTokenAuthorizationResponseBuilderTests() {
    }

    @Test
    void verifyOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("response_type", OAuth20ResponseTypes.IDTOKEN_TOKEN.getType());
        OAuth20AuthorizationRequest authzRequest = OAuth20AuthorizationRequest.builder().responseType(OAuth20ResponseTypes.IDTOKEN_TOKEN.getType()).build();
        Assertions.assertTrue((boolean)this.oidcImplicitIdTokenAndTokenCallbackUrlBuilder.supports(authzRequest));
    }

    @Test
    void verifyBuild() throws Exception {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("state", Collections.singletonList("state"));
        attributes.put("nonce", Collections.singletonList("nonce"));
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser");
        OidcRegisteredService registeredService = OidcImplicitIdTokenAndTokenAuthorizationResponseBuilderTests.getOidcRegisteredService(UUID.randomUUID().toString());
        OAuth20Code code = this.addCode(principal, (OAuthRegisteredService)registeredService);
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("casuser");
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().token((OAuth20Token)code).clientId(registeredService.getClientId()).service(CoreAuthenticationTestUtils.getService()).authentication(RegisteredServiceTestUtils.getAuthentication((Principal)principal, attributes)).registeredService((OAuthRegisteredService)registeredService).grantType(OAuth20GrantTypes.AUTHORIZATION_CODE).responseType(OAuth20ResponseTypes.IDTOKEN_TOKEN).userProfile((UserProfile)profile).redirectUri("https://oauth.example.org").ticketGrantingTicket((TicketGrantingTicket)new MockTicketGrantingTicket("casuser")).build();
        this.servicesManager.save((RegisteredService)registeredService);
        ModelAndView mv = this.oidcImplicitIdTokenAndTokenCallbackUrlBuilder.build(holder);
        Assertions.assertNotNull((Object)mv);
    }
}

