/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
class OidcImplicitIdTokenAuthorizationResponseBuilderTests
extends AbstractOidcTests {
    OidcImplicitIdTokenAuthorizationResponseBuilderTests() {
    }

    @Test
    void verifyOperation() {
        OAuth20AuthorizationRequest authzRequest = OAuth20AuthorizationRequest.builder().responseType(OAuth20ResponseTypes.ID_TOKEN.getType()).build();
        Assertions.assertTrue((boolean)this.oidcImplicitIdTokenCallbackUrlBuilder.supports(authzRequest));
    }

    @Test
    void verifyBuild() throws Exception {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("state", Collections.singletonList("state"));
        attributes.put("nonce", Collections.singletonList("nonce"));
        OidcRegisteredService registeredService = OidcImplicitIdTokenAuthorizationResponseBuilderTests.getOidcRegisteredService(UUID.randomUUID().toString());
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser");
        Authentication authentication = RegisteredServiceTestUtils.getAuthentication((Principal)principal, attributes);
        OAuth20Code code = this.addCode(principal, (OAuthRegisteredService)registeredService);
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("casuser");
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().clientId(registeredService.getClientId()).service(CoreAuthenticationTestUtils.getService()).authentication(authentication).registeredService((OAuthRegisteredService)registeredService).grantType(OAuth20GrantTypes.AUTHORIZATION_CODE).responseType(OAuth20ResponseTypes.ID_TOKEN).ticketGrantingTicket((TicketGrantingTicket)new MockTicketGrantingTicket("casuser")).token((OAuth20Token)code).userProfile((UserProfile)profile).redirectUri("https://oauth.example.org").build();
        this.servicesManager.save((RegisteredService)registeredService);
        ModelAndView mv = this.oidcImplicitIdTokenCallbackUrlBuilder.build(holder);
        Assertions.assertNotNull((Object)mv);
    }
}

