/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers;

import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Set;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.introspection.OidcIntrospectionEndpointController;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.web.response.introspection.success.OAuth20IntrospectionAccessTokenSuccessResponse;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.EncodingUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.discovery.introspection-signed-response-alg-values-supported=RS256,RS384,RS512", "cas.authn.oidc.discovery.introspection-encrypted-response-alg-values-supported=RSA-OAEP-256"})
class OidcIntrospectionEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcIntrospectionEndpointController")
    protected OidcIntrospectionEndpointController oidcIntrospectionEndpointController;

    OidcIntrospectionEndpointControllerTests() {
    }

    @Test
    void verifyOperationWithValidTicketAsJwtSignedEncrypted() throws Exception {
        MockHttpServletRequest request = OidcIntrospectionEndpointControllerTests.getHttpRequestForEndpoint("introspect");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addHeader("Accept", (Object)"application/token-introspection+jwt");
        OAuth20AccessToken accessToken = this.getAccessToken(UUID.randomUUID().toString());
        String value = EncodingUtils.encodeBase64((byte[])(accessToken.getClientId() + ":secret").getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", (Object)("Basic " + value));
        OidcRegisteredService oidcRegisteredService = OidcIntrospectionEndpointControllerTests.getOidcRegisteredService(accessToken.getClientId());
        oidcRegisteredService.setIntrospectionSignedResponseAlg("RS256");
        oidcRegisteredService.setIntrospectionEncryptedResponseAlg("RSA-OAEP-256");
        oidcRegisteredService.setIntrospectionEncryptedResponseEncoding("A128CBC-HS256");
        this.servicesManager.save((RegisteredService)oidcRegisteredService);
        this.ticketRegistry.addTicket((Ticket)accessToken);
        request.addParameter("token", accessToken.getId());
        ResponseEntity result = this.oidcIntrospectionEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertTrue((boolean)(JWTParser.parse((String)result.getBody().toString()) instanceof EncryptedJWT));
        Assertions.assertEquals((Object)"application/token-introspection+jwt", (Object)result.getHeaders().getContentType().toString());
    }

    @Test
    void verifyOperationWithValidTicketAsJwtSigned() throws Exception {
        MockHttpServletRequest request = OidcIntrospectionEndpointControllerTests.getHttpRequestForEndpoint("introspect");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addHeader("Accept", (Object)"application/token-introspection+jwt");
        OAuth20AccessToken accessToken = this.getAccessToken(UUID.randomUUID().toString());
        String value = EncodingUtils.encodeBase64((byte[])(accessToken.getClientId() + ":secret").getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", (Object)("Basic " + value));
        OidcRegisteredService oidcRegisteredService = OidcIntrospectionEndpointControllerTests.getOidcRegisteredService(accessToken.getClientId());
        oidcRegisteredService.setIntrospectionSignedResponseAlg("RS512");
        this.servicesManager.save((RegisteredService)oidcRegisteredService);
        this.ticketRegistry.addTicket((Ticket)accessToken);
        request.addParameter("token", accessToken.getId());
        Object result = this.oidcIntrospectionEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response).getBody();
        Assertions.assertTrue((boolean)(JWTParser.parse((String)result.toString()) instanceof SignedJWT));
    }

    @Test
    void verifyOperationWithValidTicketAsJwtSignedWithNone() throws Exception {
        MockHttpServletRequest request = OidcIntrospectionEndpointControllerTests.getHttpRequestForEndpoint("introspect");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addHeader("Accept", (Object)"application/token-introspection+jwt");
        OAuth20AccessToken accessToken = this.getAccessToken(UUID.randomUUID().toString());
        String value = EncodingUtils.encodeBase64((byte[])(accessToken.getClientId() + ":secret").getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", (Object)("Basic " + value));
        OidcRegisteredService oidcRegisteredService = OidcIntrospectionEndpointControllerTests.getOidcRegisteredService(accessToken.getClientId());
        oidcRegisteredService.setIntrospectionSignedResponseAlg("none");
        this.servicesManager.save((RegisteredService)oidcRegisteredService);
        this.ticketRegistry.addTicket((Ticket)accessToken);
        request.addParameter("token", accessToken.getId());
        ResponseEntity result = this.oidcIntrospectionEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertTrue((boolean)result.getStatusCode().is4xxClientError());
    }

    @Test
    void verifyOperationWithValidTicketAsJwtSignedWithNoneEncryption() throws Exception {
        MockHttpServletRequest request = OidcIntrospectionEndpointControllerTests.getHttpRequestForEndpoint("introspect");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addHeader("Accept", (Object)"application/token-introspection+jwt");
        OAuth20AccessToken accessToken = this.getAccessToken(UUID.randomUUID().toString());
        String value = EncodingUtils.encodeBase64((byte[])(accessToken.getClientId() + ":secret").getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", (Object)("Basic " + value));
        OidcRegisteredService oidcRegisteredService = OidcIntrospectionEndpointControllerTests.getOidcRegisteredService(accessToken.getClientId());
        oidcRegisteredService.setIntrospectionEncryptedResponseAlg("none");
        this.servicesManager.save((RegisteredService)oidcRegisteredService);
        this.ticketRegistry.addTicket((Ticket)accessToken);
        request.addParameter("token", accessToken.getId());
        ResponseEntity result = this.oidcIntrospectionEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertTrue((boolean)result.getStatusCode().is4xxClientError());
    }

    @Test
    void verifyOperationWithValidTicketAsJwtPlain() throws Exception {
        MockHttpServletRequest request = OidcIntrospectionEndpointControllerTests.getHttpRequestForEndpoint("introspect");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addHeader("Accept", (Object)"application/token-introspection+jwt");
        OAuth20AccessToken accessToken = this.getAccessToken(UUID.randomUUID().toString());
        String value = EncodingUtils.encodeBase64((byte[])(accessToken.getClientId() + ":secret").getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", (Object)("Basic " + value));
        OidcRegisteredService oidcRegisteredService = OidcIntrospectionEndpointControllerTests.getOidcRegisteredService(accessToken.getClientId());
        oidcRegisteredService.setIntrospectionSignedResponseAlg(null);
        this.servicesManager.save((RegisteredService)oidcRegisteredService);
        this.ticketRegistry.addTicket((Ticket)accessToken);
        request.addParameter("token", accessToken.getId());
        ResponseEntity result = this.oidcIntrospectionEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertTrue((boolean)(JWTParser.parse((String)result.getBody().toString()) instanceof PlainJWT));
        Assertions.assertEquals((Object)"application/token-introspection+jwt", (Object)result.getHeaders().getContentType().toString());
    }

    @Test
    void verifyOperationWithValidTicket() throws Exception {
        MockHttpServletRequest request = OidcIntrospectionEndpointControllerTests.getHttpRequestForEndpoint("introspect");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String value = EncodingUtils.encodeBase64((byte[])"clientid:secret".getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", (Object)("Basic " + value));
        OAuth20AccessToken accessToken = this.getAccessToken();
        this.servicesManager.save((RegisteredService)OidcIntrospectionEndpointControllerTests.getOidcRegisteredService());
        this.ticketRegistry.addTicket((Ticket)accessToken);
        request.addParameter("token", accessToken.getId());
        ResponseEntity result = this.oidcIntrospectionEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        OAuth20IntrospectionAccessTokenSuccessResponse body = (OAuth20IntrospectionAccessTokenSuccessResponse)result.getBody();
        Assertions.assertNotNull((Object)body);
        Assertions.assertTrue((boolean)Instant.ofEpochSecond(body.getExp()).isAfter(Instant.ofEpochSecond(body.getIat())));
        Assertions.assertTrue((boolean)body.isActive());
        Assertions.assertEquals((Object)accessToken.getScopes(), Set.of(body.getScope().split(" ")));
    }

    @Test
    void verifyBadEndpointRequest() {
        MockHttpServletRequest request = OidcIntrospectionEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity mv = this.oidcIntrospectionEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)mv.getStatusCode());
    }

    @Test
    void verifyOperationWithInvalidTicket() throws Exception {
        MockHttpServletRequest request = OidcIntrospectionEndpointControllerTests.getHttpRequestForEndpoint("introspect");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String auth = "clientid:secret";
        String value = EncodingUtils.encodeBase64((byte[])"clientid:secret".getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", (Object)("Basic " + value));
        OAuth20AccessToken accessToken = this.getAccessToken();
        this.servicesManager.save((RegisteredService)OidcIntrospectionEndpointControllerTests.getOidcRegisteredService());
        request.addParameter("token", accessToken.getId());
        ResponseEntity result = this.oidcIntrospectionEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)result.getStatusCode());
        OAuth20IntrospectionAccessTokenSuccessResponse body = (OAuth20IntrospectionAccessTokenSuccessResponse)result.getBody();
        Assertions.assertNotNull((Object)body);
        Assertions.assertFalse((boolean)body.isActive());
    }
}

