/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.discovery.OidcWellKnownEndpointController;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class OidcWellKnownEndpointControllerTests
extends AbstractOidcTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    @Autowired
    @Qualifier(value="oidcWellKnownController")
    protected OidcWellKnownEndpointController oidcWellKnownController;

    OidcWellKnownEndpointControllerTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        MockHttpServletRequest request = OidcWellKnownEndpointControllerTests.getHttpRequestForEndpoint("unknown/.well-known");
        request.setRequestURI("unknown/issuer");
        ResponseEntity entity = this.oidcWellKnownController.getWellKnownDiscoveryConfiguration((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertEquals((Object)HttpStatus.NOT_FOUND, (Object)entity.getStatusCode());
        request = OidcWellKnownEndpointControllerTests.getHttpRequestForEndpoint(".well-known");
        entity = this.oidcWellKnownController.getWellKnownDiscoveryConfiguration((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)entity.getStatusCode());
        String res1 = MAPPER.writeValueAsString((Object)entity);
        Assertions.assertNotNull((Object)res1);
        request = OidcWellKnownEndpointControllerTests.getHttpRequestForEndpoint(".well-known/openid-configuration");
        entity = this.oidcWellKnownController.getWellKnownOpenIdDiscoveryConfiguration((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)entity.getStatusCode());
        String res2 = MAPPER.writeValueAsString((Object)entity);
        Assertions.assertNotNull((Object)res2);
    }
}

