/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.authorize;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import java.util.UUID;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.web.controllers.authorize.OidcAuthorizeEndpointController;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OIDC")
class OidcAuthorizeEndpointControllerTests {
    OidcAuthorizeEndpointControllerTests() {
    }

    @Nested
    class DefaultAuthorizationRequests
    extends AbstractOidcTests {
        @Autowired
        @Qualifier(value="oidcAuthorizeController")
        protected OidcAuthorizeEndpointController oidcAuthorizeEndpointController;

        DefaultAuthorizationRequests() {
        }

        @Test
        void verifyBadEndpointRequest() throws Exception {
            MockHttpServletRequest request = DefaultAuthorizationRequests.getHttpRequestForEndpoint("unknown/issuer");
            request.setRequestURI("unknown/issuer");
            MockHttpServletResponse response = new MockHttpServletResponse();
            ModelAndView mv = this.oidcAuthorizeEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)mv.getStatus());
        }

        @Test
        void verifyUnknownPrompt() throws Exception {
            String id = UUID.randomUUID().toString();
            OidcRegisteredService service = DefaultAuthorizationRequests.getOidcRegisteredService(id);
            service.setBypassApprovalPrompt(true);
            this.servicesManager.save((RegisteredService)service);
            MockHttpServletRequest mockRequest = DefaultAuthorizationRequests.getHttpRequestForEndpoint("oidcAuthorize");
            mockRequest.setMethod(HttpMethod.GET.name());
            mockRequest.setParameter("client_id", id);
            mockRequest.setParameter("prompt", "unknown");
            mockRequest.setContextPath("");
            mockRequest.setQueryString("prompt=unknown");
            MockHttpServletResponse mockResponse = new MockHttpServletResponse();
            ModelAndView mv = this.oidcAuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
            Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)mv.getStatus());
        }

        @Test
        void verify() throws Exception {
            String id = UUID.randomUUID().toString();
            MockHttpServletRequest mockRequest = DefaultAuthorizationRequests.getHttpRequestForEndpoint("oidcAuthorize");
            mockRequest.setMethod(HttpMethod.GET.name());
            mockRequest.setParameter("client_id", id);
            mockRequest.setParameter("redirect_uri", "https://oauth.example.org/");
            mockRequest.setParameter("response_type", OAuth20ResponseTypes.TOKEN.name().toLowerCase(Locale.ENGLISH));
            mockRequest.setContextPath("");
            MockHttpServletResponse mockResponse = new MockHttpServletResponse();
            OidcConfigurationContext oauthContext = (OidcConfigurationContext)this.oidcAuthorizeEndpointController.getConfigurationContext();
            oauthContext.getCasProperties().getAuthn().getOauth().getSessionReplication().getCookie().setAutoConfigureCookiePath(false);
            oauthContext.getOauthDistributedSessionCookieGenerator().setCookiePath("");
            OidcRegisteredService service = DefaultAuthorizationRequests.getOidcRegisteredService(id);
            service.setBypassApprovalPrompt(true);
            this.servicesManager.save((RegisteredService)service);
            CasProfile profile = new CasProfile();
            profile.setId("casuser");
            SessionStore sessionStore = ((OidcConfigurationContext)this.oidcAuthorizeEndpointController.getConfigurationContext()).getSessionStore();
            JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
            MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
            ((OidcConfigurationContext)this.oidcAuthorizeEndpointController.getConfigurationContext()).getTicketRegistry().addTicket((Ticket)ticket);
            profile.addAttribute(TicketGrantingTicket.class.getName(), (Object)ticket.getId());
            sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            ModelAndView modelAndView = this.oidcAuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
            View view = modelAndView.getView();
            Assertions.assertTrue((boolean)(view instanceof RedirectView));
            String url = ((AbstractUrlBasedView)view).getUrl();
            Assertions.assertTrue((boolean)url.startsWith("https://oauth.example.org/"));
            String fragment = new URIBuilder(url).getFragment();
            Assertions.assertTrue((boolean)fragment.contains("access_token"));
            Assertions.assertTrue((boolean)fragment.contains("expires_in"));
            Assertions.assertTrue((boolean)fragment.contains("token_type"));
        }
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oidc.discovery.require-pushed-authorization-requests=true"})
    class PushedAuthorizationRequests
    extends AbstractOidcTests {
        @Autowired
        @Qualifier(value="oidcAuthorizeController")
        protected OidcAuthorizeEndpointController oidcAuthorizeEndpointController;

        PushedAuthorizationRequests() {
        }

        @Test
        void verifyBadEndpointRequest() throws Exception {
            String id = UUID.randomUUID().toString();
            MockHttpServletRequest request = PushedAuthorizationRequests.getHttpRequestForEndpoint("oidcAuthorize");
            request.setMethod(HttpMethod.GET.name());
            request.setParameter("client_id", id);
            MockHttpServletResponse response = new MockHttpServletResponse();
            ModelAndView mv = this.oidcAuthorizeEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assertions.assertEquals((Object)HttpStatus.FORBIDDEN, (Object)mv.getStatus());
        }
    }
}

