/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.authorize;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import java.util.UUID;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.web.controllers.authorize.OidcPushedAuthorizeEndpointController;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.discovery.require-pushed-authorization-requests=true"})
class OidcPushedAuthorizeEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcPushedAuthorizeController")
    protected OidcPushedAuthorizeEndpointController oidcPushedAuthorizeController;

    OidcPushedAuthorizeEndpointControllerTests() {
    }

    @Test
    void verifyGetOperationFails() throws Exception {
        Assertions.assertNotNull((Object)this.oidcPushedAuthorizeController);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod(HttpMethod.GET.name());
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assertions.assertEquals((Object)HttpStatus.METHOD_NOT_ALLOWED, (Object)this.oidcPushedAuthorizeController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response).getStatus());
        request.setMethod(HttpMethod.POST.name());
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)this.oidcPushedAuthorizeController.handleRequestPost((HttpServletRequest)request, (HttpServletResponse)response).getStatus());
    }

    @Test
    void verifyOperation() throws Exception {
        String id = UUID.randomUUID().toString();
        MockHttpServletRequest mockRequest = OidcPushedAuthorizeEndpointControllerTests.getHttpRequestForEndpoint("oidcPushAuthorize");
        mockRequest.setMethod(HttpMethod.GET.name());
        mockRequest.setParameter("client_id", id);
        mockRequest.setParameter("redirect_uri", "https://oauth.example.org/");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.TOKEN.name().toLowerCase(Locale.ENGLISH));
        mockRequest.setContextPath("");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OidcConfigurationContext oauthContext = (OidcConfigurationContext)this.oidcPushedAuthorizeController.getConfigurationContext();
        oauthContext.getCasProperties().getAuthn().getOauth().getSessionReplication().getCookie().setAutoConfigureCookiePath(false);
        oauthContext.getOauthDistributedSessionCookieGenerator().setCookiePath("");
        OidcRegisteredService service = OidcPushedAuthorizeEndpointControllerTests.getOidcRegisteredService(id);
        service.setBypassApprovalPrompt(true);
        this.servicesManager.save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        SessionStore sessionStore = ((OidcConfigurationContext)this.oidcPushedAuthorizeController.getConfigurationContext()).getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        ((OidcConfigurationContext)this.oidcPushedAuthorizeController.getConfigurationContext()).getTicketRegistry().addTicket((Ticket)ticket);
        sessionStore.set((WebContext)context, "ticketGrantingTicketId", (Object)ticket.getId());
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        ModelAndView modelAndView = this.oidcPushedAuthorizeController.handleRequestPost((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertNotNull((Object)modelAndView);
    }
}

